/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import com.sun.media.jai.opimage.RIFUtil;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.warp.WarpBicubicOpImage;
import it.geosolutions.jaiext.warp.WarpBilinearOpImage;
import it.geosolutions.jaiext.warp.WarpGeneralOpImage;
import it.geosolutions.jaiext.warp.WarpNearestOpImage;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.Warp;

public class WarpRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint(renderHints);
        BorderExtender extender = RIFUtil.getBorderExtenderHint(renderHints);
        RenderedImage source = paramBlock.getRenderedSource(0);
        Warp warp = (Warp)paramBlock.getObjectParameter(0);
        Interpolation interp = (Interpolation)paramBlock.getObjectParameter(1);
        double[] backgroundValues = (double[])paramBlock.getObjectParameter(2);
        ROI roi = null;
        Object roi_ = paramBlock.getObjectParameter(3);
        if (roi_ instanceof ROI) {
            roi = (ROI)roi_;
            PlanarImage temp = PlanarImage.wrapRenderedImage(source);
            temp.setProperty("ROI", roi);
            source = temp;
        }
        Range noData = (Range)paramBlock.getObjectParameter(4);
        noData = RangeFactory.convert(noData, source.getSampleModel().getDataType());
        if (interp instanceof InterpolationNearest || interp instanceof javax.media.jai.InterpolationNearest) {
            return new WarpNearestOpImage(source, renderHints, layout, warp, interp, roi, noData, backgroundValues);
        }
        if (interp instanceof InterpolationBilinear || interp instanceof javax.media.jai.InterpolationBilinear) {
            return new WarpBilinearOpImage(source, extender, renderHints, layout, warp, interp, roi, noData, backgroundValues);
        }
        if (interp instanceof InterpolationBicubic || interp instanceof javax.media.jai.InterpolationBicubic || interp instanceof InterpolationBicubic2) {
            return new WarpBicubicOpImage(source, extender, renderHints, layout, warp, interp, roi, noData, backgroundValues);
        }
        return new WarpGeneralOpImage(source, extender, renderHints, layout, warp, interp, backgroundValues, roi, noData);
    }
}

