/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.measure.Unit;
import javax.media.jai.ImageFunction;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.RenderedSampleDimension;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.util.factory.AbstractFactory;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

public class GridCoverageFactory
extends AbstractFactory {
    private final Hints userHints = null;

    public GridCoverageFactory() {
        this(null);
    }

    public GridCoverageFactory(Hints userHints) {
        String tileEncoding = null;
        if (userHints != null && (tileEncoding = (String)userHints.get(Hints.TILE_ENCODING)) != null && (tileEncoding = tileEncoding.trim()).length() == 0) {
            tileEncoding = null;
        }
        this.hints.put(Hints.TILE_ENCODING, tileEncoding);
    }

    protected CoordinateReferenceSystem getDefaultCRS(int dimension) {
        CoordinateReferenceSystem candidate = (CoordinateReferenceSystem)this.hints.get(Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (candidate != null) {
            return candidate;
        }
        switch (dimension) {
            case 2: {
                return DefaultEngineeringCRS.CARTESIAN_2D;
            }
            case 3: {
                return DefaultEngineeringCRS.CARTESIAN_3D;
            }
        }
        throw new IllegalArgumentException(Errors.format(58, "dimension", dimension));
    }

    public GridCoverage2D create(CharSequence name, ImageFunction function, GridGeometry2D gridGeometry, GridSampleDimension[] bands, Map<?, ?> properties) {
        MathTransform2D transform = gridGeometry.getGridToCRS2D();
        if (!(transform instanceof AffineTransform)) {
            throw new IllegalArgumentException(Errors.format(118));
        }
        AffineTransform at = (AffineTransform)((Object)transform);
        if (at.getShearX() != 0.0 || at.getShearY() != 0.0) {
            throw new IllegalArgumentException("Shear and rotation not supported");
        }
        double xScale = at.getScaleX();
        double yScale = at.getScaleY();
        double xTrans = -at.getTranslateX() / xScale;
        double yTrans = -at.getTranslateY() / yScale;
        GridEnvelope range = gridGeometry.getGridRange();
        PlanarImage image = new ImageWorker().function(function, range.getSpan(0), range.getSpan(1), (float)xScale, (float)yScale, (float)xTrans, (float)yTrans).getPlanarImage();
        return this.create(name, (RenderedImage)image, gridGeometry, bands, null, properties);
    }

    public GridCoverage2D create(CharSequence name, float[][] matrix, Envelope envelope) {
        int width = 0;
        int height = matrix.length;
        for (float[] row : matrix) {
            if (row == null || row.length <= width) continue;
            width = row.length;
        }
        WritableRaster raster = RasterFactory.createBandedRaster(4, width, height, 1, null);
        for (int j = 0; j < height; ++j) {
            int i;
            float[] row;
            row = matrix[j];
            if (row != null) {
                for (i = 0; i < row.length; ++i) {
                    raster.setSample(i, j, 0, row[i]);
                }
            }
            while (i < width) {
                raster.setSample(i, j, 0, Float.NaN);
                ++i;
            }
        }
        return this.create(name, raster, envelope);
    }

    public GridCoverage2D create(CharSequence name, WritableRaster raster, Envelope envelope) {
        return this.create(name, raster, envelope, null, null, null, null, null);
    }

    public GridCoverage2D create(CharSequence name, WritableRaster raster, Envelope envelope, double[] minValues, double[] maxValues, Unit<?> units, Color[][] colors, RenderingHints hints) {
        GridSampleDimension[] bands = RenderedSampleDimension.create(name, raster, minValues, maxValues, units, colors, hints);
        ColorModel model = bands[0].getColorModel(0, bands.length, raster.getSampleModel().getDataType());
        BufferedImage image = new BufferedImage(model, raster, false, null);
        return this.create(name, (RenderedImage)image, envelope, bands, null, null);
    }

    public GridCoverage2D create(CharSequence name, WritableRaster raster, CoordinateReferenceSystem crs, MathTransform gridToCRS, double[] minValues, double[] maxValues, Unit<?> units, Color[][] colors, RenderingHints hints) {
        GridSampleDimension[] bands = RenderedSampleDimension.create(name, raster, minValues, maxValues, units, colors, hints);
        ColorModel model = bands[0].getColorModel(0, bands.length, raster.getDataBuffer().getDataType());
        BufferedImage image = new BufferedImage(model, raster, false, null);
        return this.create(name, image, crs, gridToCRS, bands, null, null);
    }

    public GridCoverage2D create(CharSequence name, WritableRaster raster, Envelope envelope, GridSampleDimension[] bands) {
        if (bands == null) {
            bands = RenderedSampleDimension.create(name, raster, null, null, null, null, null);
        }
        ColorModel model = bands[0].getColorModel(0, bands.length, raster.getDataBuffer().getDataType());
        BufferedImage image = new BufferedImage(model, raster, false, null);
        return this.create(name, (RenderedImage)image, envelope, bands, null, null);
    }

    public GridCoverage2D create(CharSequence name, WritableRaster raster, CoordinateReferenceSystem crs, MathTransform gridToCRS, GridSampleDimension[] bands) {
        if (bands == null) {
            bands = RenderedSampleDimension.create(name, raster, null, null, null, null, null);
        }
        ColorModel model = bands[0].getColorModel(0, bands.length, raster.getDataBuffer().getDataType());
        BufferedImage image = new BufferedImage(model, raster, false, null);
        return this.create(name, image, crs, gridToCRS, bands, null, null);
    }

    public GridCoverage2D create(CharSequence name, RenderedImage image, Envelope envelope) {
        return this.create(name, image, envelope, null, null, null);
    }

    public GridCoverage2D create(CharSequence name, RenderedImage image, Envelope envelope, GridSampleDimension[] bands, GridCoverage[] sources, Map<?, ?> properties) {
        if (envelope.getCoordinateReferenceSystem() == null) {
            GeneralEnvelope e = new GeneralEnvelope(envelope);
            e.setCoordinateReferenceSystem(this.getDefaultCRS(e.getDimension()));
            envelope = e;
        }
        GridGeometry2D gm = new GridGeometry2D(new GeneralGridEnvelope(image, envelope.getDimension()), envelope);
        return this.create(name, image, gm, bands, sources, properties);
    }

    public GridCoverage2D create(CharSequence name, RenderedImage image, CoordinateReferenceSystem crs, MathTransform gridToCRS, GridSampleDimension[] bands, GridCoverage[] sources, Map<?, ?> properties) {
        GridGeometry2D gm = new GridGeometry2D(new GeneralGridEnvelope(image, crs.getCoordinateSystem().getDimension()), gridToCRS, crs);
        return this.create(name, image, gm, bands, sources, properties);
    }

    public GridCoverage2D create(CharSequence name, RenderedImage image, GridGeometry2D gridGeometry, GridSampleDimension[] bands, GridCoverage[] sources, Map<?, ?> properties) {
        if (!gridGeometry.isDefined(1)) {
            int dimension = gridGeometry.getDimension();
            gridGeometry = new GridGeometry2D(gridGeometry, this.getDefaultCRS(dimension));
        }
        GridCoverage2D coverage = new GridCoverage2D(name, PlanarImage.wrapRenderedImage(image), gridGeometry, bands, sources, properties, this.userHints);
        coverage.tileEncoding = (String)this.hints.get(Hints.TILE_ENCODING);
        return coverage;
    }
}

