/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.DiffTransactionState;
import org.geotools.data.store.EventContentFeatureWriter;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

public abstract class ContentFeatureStore
extends ContentFeatureSource
implements SimpleFeatureStore,
SimpleFeatureLocking {
    protected final int WRITER_ADD = 1;
    protected final int WRITER_UPDATE = 2;
    protected final int WRITER_COMMIT = 4;
    public static final String ORIGINAL_FEATURE_KEY = "_original_";

    public ContentFeatureStore(ContentEntry entry, Query query) {
        super(entry, query);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Filter filter) throws IOException {
        return this.getWriter(filter, 3);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Filter filter, int flags) throws IOException {
        return this.getWriter(new Query(this.getSchema().getTypeName(), filter), flags);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Query query) throws IOException {
        return this.getWriter(query, 3);
    }

    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(Query query, int flags) throws IOException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer;
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        if (!this.canTransact() && this.transaction != null && this.transaction != Transaction.AUTO_COMMIT) {
            if ((flags | 4) == 4) {
                writer = this.getWriterInternal(query, flags);
                if (!this.canFilter() && query.getFilter() != null && query.getFilter() != Filter.INCLUDE) {
                    writer = new FilteringFeatureWriter(writer, query.getFilter());
                }
            } else {
                DiffTransactionState state = (DiffTransactionState)this.getTransaction().getState(this.getEntry());
                FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getReader(query);
                writer = state.diffWriter(this, reader);
            }
        } else {
            writer = this.getWriterInternal(query, flags);
            if (!this.canEvent()) {
                writer = new EventContentFeatureWriter(this, writer);
            }
            if (!this.canFilter() && query.getFilter() != null && query.getFilter() != Filter.INCLUDE) {
                writer = new FilteringFeatureWriter(writer, query.getFilter());
            }
        }
        if (!this.canLock()) {
            InProcessLockingManager lockingManager = (InProcessLockingManager)this.getDataStore().getLockingManager();
            writer = lockingManager.checkedWriter(writer, this.transaction);
        }
        return writer;
    }

    protected abstract FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query var1, int var2) throws IOException;

    public List<FeatureId> addFeatures(Collection collection) throws IOException {
        ArrayList<FeatureId> ids = new ArrayList<FeatureId>(collection.size());
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriterAppend();){
            for (Object o : collection) {
                FeatureId id = this.addFeature((SimpleFeature)o, writer);
                ids.add(id);
            }
        }
        return ids;
    }

    @Override
    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) throws IOException {
        ArrayList<FeatureId> ids = new ArrayList<FeatureId>();
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriterAppend();
             FeatureIterator<SimpleFeature> f = featureCollection.features();){
            while (f.hasNext()) {
                SimpleFeature feature = f.next();
                FeatureId id = this.addFeature(feature, writer);
                ids.add(id);
            }
        }
        return ids;
    }

    private FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterAppend() throws IOException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter(Filter.INCLUDE, 1);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    FeatureId addFeature(SimpleFeature feature, FeatureWriter<SimpleFeatureType, SimpleFeature> writer) throws IOException {
        SimpleFeature toWrite = writer.next();
        for (int i = 0; i < toWrite.getType().getAttributeCount(); ++i) {
            String name = toWrite.getType().getDescriptor(i).getLocalName();
            toWrite.setAttribute(name, feature.getAttribute(name));
        }
        toWrite.getUserData().putAll(feature.getUserData());
        boolean useExisting = Boolean.TRUE.equals(feature.getUserData().get(Hints.USE_PROVIDED_FID));
        if (this.getQueryCapabilities().isUseProvidedFIDSupported() && useExisting) {
            ((FeatureIdImpl)toWrite.getIdentifier()).setID(feature.getID());
        }
        toWrite.getUserData().put(ORIGINAL_FEATURE_KEY, feature);
        writer.write();
        feature.getUserData().putAll(toWrite.getUserData());
        feature.getUserData().remove(ORIGINAL_FEATURE_KEY);
        return toWrite.getIdentifier();
    }

    @Override
    public final void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        this.removeFeatures(Filter.INCLUDE);
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter(Filter.INCLUDE, 1);){
            while (reader.hasNext()) {
                SimpleFeature feature = reader.next();
                SimpleFeature toWrite = writer.next();
                for (int i = 0; i < toWrite.getType().getAttributeCount(); ++i) {
                    String name = toWrite.getType().getDescriptor(i).getLocalName();
                    toWrite.setAttribute(name, feature.getAttribute(name));
                }
                writer.write();
            }
        }
    }

    public void modifyFeatures(AttributeDescriptor[] type, Object[] value, Filter filter) throws IOException {
        Name[] attributeNames = new Name[type.length];
        for (int i = 0; i < type.length; ++i) {
            attributeNames[i] = type[i].getName();
        }
        this.modifyFeatures(attributeNames, value, filter);
    }

    @Override
    public void modifyFeatures(Name[] type, Object[] value, Filter filter) throws IOException {
        if (filter == null) {
            String msg = "Must specify a filter, must not be null.";
            throw new IllegalArgumentException(msg);
        }
        filter = this.resolvePropertyNames(filter);
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter(filter, 2);){
            while (writer.hasNext()) {
                SimpleFeature toWrite = writer.next();
                for (int i = 0; i < type.length; ++i) {
                    toWrite.setAttribute(type[i], value[i]);
                }
                writer.write();
            }
        }
    }

    @Override
    public final void modifyFeatures(String name, Object attributeValue, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{new NameImpl(name)}, new Object[]{attributeValue}, filter);
    }

    @Override
    public final void modifyFeatures(String[] names, Object[] values, Filter filter) throws IOException {
        Name[] attributeNames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            attributeNames[i] = new NameImpl(names[i]);
        }
        this.modifyFeatures(attributeNames, values, filter);
    }

    public final void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{type.getName()}, new Object[]{value}, filter);
    }

    @Override
    public final void modifyFeatures(Name name, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{name}, new Object[]{value}, filter);
    }

    @Override
    public void removeFeatures(Filter filter) throws IOException {
        if (filter == null) {
            String msg = "Must specify a filter, must not be null.";
            throw new IllegalArgumentException(msg);
        }
        filter = this.resolvePropertyNames(filter);
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriter(filter, 2);){
            while (writer.hasNext()) {
                writer.next();
                writer.remove();
            }
        }
    }
}

