/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import javax.xml.namespace.QName;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class QNameConverterFactory
implements ConverterFactory {
    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (target.equals(String.class) && source.equals(QName.class)) {
            return new Converter(){

                @Override
                public <T> T convert(Object source, Class<T> target) throws Exception {
                    QName qname = (QName)source;
                    if (qname.getPrefix() == null || "".equals(qname.getPrefix())) {
                        return target.cast(qname.getLocalPart());
                    }
                    return target.cast(qname.getPrefix() + ":" + qname.getLocalPart());
                }
            };
        }
        return null;
    }
}

