/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureIterator;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.GeometryDescriptor;

public class ClippingFeatureIterator
extends DecoratingSimpleFeatureIterator {
    private FeatureIterator<SimpleFeature> delegate;
    private SimpleFeature next;

    public ClippingFeatureIterator(SimpleFeatureIterator iterator) {
        super(iterator);
        this.delegate = iterator;
    }

    @Override
    public SimpleFeature next() throws NoSuchElementException {
        if (this.next == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        SimpleFeature f = this.next;
        this.next = null;
        return f;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.delegate.hasNext()) {
            SimpleFeature peek = this.delegate.next();
            GeometryDescriptor descriptor = peek.getFeatureType().getGeometryDescriptor();
            if (peek.hasUserData()) {
                Geometry geom;
                Geometry clip = (Geometry)peek.getUserData().get(Hints.GEOMETRY_CLIP);
                if (!clip.intersects(geom = (Geometry)peek.getAttribute(descriptor.getName()))) continue;
                this.next = peek;
                break;
            }
            this.next = peek;
            break;
        }
        return this.next != null;
    }

    @Override
    public void close() {
        this.delegate.close();
        this.delegate = null;
        this.next = null;
    }
}

