/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.visitor.FeatureCalc;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;

public class CollectionUtil {
    static void accept(SimpleFeatureCollection collection, FeatureVisitor visitor) {
        try (SimpleFeatureIterator iterator = collection.features();){
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                visitor.visit(feature);
            }
        }
    }

    static void accept(SimpleFeatureCollection collection, FeatureVisitor ... visitors) {
        try (SimpleFeatureIterator iterator = collection.features();){
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                for (FeatureVisitor visitor : visitors) {
                    visitor.visit(feature);
                }
            }
        }
    }

    public static Object calc(SimpleFeatureCollection collection, FeatureCalc calculator) {
        CollectionUtil.accept(collection, (FeatureVisitor)calculator);
        return calculator.getResult();
    }
}

