/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.Arrays;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CurvedRing;
import org.geotools.geometry.jts.GrowableOrdinateArray;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class CircularRing
extends LinearRing
implements SingleCurvedGeometry<LinearRing>,
CurvedRing {
    private static final long serialVersionUID = -5796254063449438787L;
    static final CoordinateSequence FAKE_RING_2D = new CoordinateArraySequence(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 1.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 0.0)});
    CircularString delegate;

    public CircularRing(CoordinateSequence points, GeometryFactory factory, double tolerance) {
        super(FAKE_RING_2D, factory);
        this.delegate = new CircularString(points, factory, tolerance);
        if (!this.delegate.isClosed()) {
            throw new IllegalArgumentException("Start and end point are not matching, this is not a ring");
        }
    }

    public CircularRing(double[] controlPoints, GeometryFactory factory, double tolerance) {
        super(FAKE_RING_2D, factory);
        this.delegate = new CircularString(controlPoints, factory, tolerance);
        if (!this.delegate.isClosed()) {
            throw new IllegalArgumentException("Start and end point are not matching, this is not a ring");
        }
    }

    @Override
    public int getNumArcs() {
        return this.delegate.getNumArcs();
    }

    @Override
    public CircularArc getArcN(int arcIndex) {
        return this.delegate.getArcN(arcIndex);
    }

    @Override
    public LinearRing linearize() {
        CoordinateSequence cs = this.delegate.getLinearizedCoordinateSequence(this.delegate.tolerance);
        return this.getFactory().createLinearRing(cs);
    }

    @Override
    public LinearRing linearize(double tolerance) {
        CoordinateSequence cs = this.delegate.getLinearizedCoordinateSequence(this.delegate.tolerance);
        return this.getFactory().createLinearRing(cs);
    }

    @Override
    public double getTolerance() {
        return this.delegate.getTolerance();
    }

    @Override
    public CoordinateSequence getLinearizedCoordinateSequence(double tolerance) {
        return this.delegate.getLinearizedCoordinateSequence(tolerance);
    }

    @Override
    public double[] getControlPoints() {
        return this.delegate.controlPoints;
    }

    public boolean isClosed() {
        return true;
    }

    public int getDimension() {
        return super.getDimension();
    }

    public int getBoundaryDimension() {
        return super.getDimension();
    }

    public boolean isEmpty() {
        return false;
    }

    public String getGeometryType() {
        return "CircularRing";
    }

    @Override
    public int getCoordinatesDimension() {
        return this.delegate.getDimension();
    }

    public CircularRing normalizeRing() {
        if (!this.isClosed() || this.getNumArcs() > 1) {
            return this;
        }
        CircularArc arc = this.getArcN(0);
        Coordinate center = arc.getCenter();
        double radius = arc.getRadius();
        double[] cp = arc.getControlPoints();
        double angle1 = Math.atan2(cp[1] - center.y, cp[0] - center.x);
        double angle2 = Math.atan2(cp[3] - center.y, cp[2] - center.x);
        double am1 = (angle1 + angle2) / 2.0;
        double am2 = am1 + Math.PI;
        double[] ncp = new double[]{cp[0], cp[1], center.x + radius * Math.cos(am1), center.y + radius * Math.sin(am1), cp[2], cp[3], center.x + radius * Math.cos(am2), center.y + radius * Math.sin(am2), cp[0], cp[1]};
        return new CircularRing(ncp, this.factory, this.delegate.getTolerance());
    }

    public CircularRing reverse() {
        return (CircularRing)super.reverse();
    }

    public CircularRing reverseInternal() {
        double[] controlPoints = this.delegate.controlPoints;
        GrowableOrdinateArray array = new GrowableOrdinateArray();
        array.addAll(controlPoints);
        array.reverseOrdinates(0, array.size() - 1);
        return new CircularRing(array.getData(), this.getFactory(), this.delegate.tolerance);
    }

    public int getNumGeometries() {
        return 1;
    }

    public Geometry getGeometryN(int n) {
        return this;
    }

    public void setUserData(Object userData) {
        super.setUserData(userData);
    }

    public int getSRID() {
        return super.getSRID();
    }

    public void setSRID(int SRID) {
        super.setSRID(SRID);
    }

    public GeometryFactory getFactory() {
        return super.getFactory();
    }

    public Object getUserData() {
        return super.getUserData();
    }

    public PrecisionModel getPrecisionModel() {
        return super.getPrecisionModel();
    }

    public boolean isRectangle() {
        return false;
    }

    public Point getInteriorPoint() {
        return this.delegate.getInteriorPoint();
    }

    public Geometry getEnvelope() {
        return this.delegate.getEnvelope();
    }

    public Envelope getEnvelopeInternal() {
        return this.delegate.getEnvelopeInternal();
    }

    protected Envelope computeEnvelopeInternal() {
        return this.delegate.getEnvelopeInternal();
    }

    public boolean equalsExact(Geometry other) {
        return this.equalsExact(other, 0.0);
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (other instanceof CircularRing) {
            CircularRing csOther = (CircularRing)other;
            if (Arrays.equals(this.delegate.controlPoints, csOther.delegate.controlPoints)) {
                return true;
            }
        }
        return this.linearize(tolerance).equalsExact(other, tolerance);
    }

    public boolean equals(Geometry other) {
        if (other instanceof CircularRing) {
            CircularRing csOther = (CircularRing)other;
            if (Arrays.equals(this.delegate.controlPoints, csOther.delegate.controlPoints)) {
                return true;
            }
        }
        return this.linearize().equals(other);
    }

    public boolean equalsTopo(Geometry other) {
        if (other instanceof CircularRing) {
            CircularRing csOther = (CircularRing)other;
            if (Arrays.equals(this.delegate.controlPoints, csOther.delegate.controlPoints)) {
                return true;
            }
        }
        return this.linearize().equalsTopo(other);
    }

    public boolean equals(Object o) {
        if (o instanceof Geometry) {
            return this.equals((Geometry)o);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.toCurvedText();
    }

    @Override
    public String toCurvedText() {
        return this.delegate.toCurvedText();
    }

    public boolean equalsNorm(Geometry g) {
        return super.equalsNorm(g);
    }

    public Coordinate[] getCoordinates() {
        return this.linearize().getCoordinates();
    }

    public CoordinateSequence getCoordinateSequence() {
        if (this.delegate != null) {
            return this.linearize().getCoordinateSequence();
        }
        return super.getCoordinateSequence();
    }

    public Coordinate getCoordinateN(int n) {
        if (this.delegate != null) {
            return this.linearize().getCoordinateN(n);
        }
        return super.getCoordinateN(n);
    }

    public Coordinate getCoordinate() {
        return this.linearize().getCoordinate();
    }

    public int getNumPoints() {
        if (this.delegate != null) {
            return this.linearize().getNumPoints();
        }
        return super.getNumPoints();
    }

    public Point getPointN(int n) {
        return this.linearize().getPointN(n);
    }

    public Point getStartPoint() {
        return this.linearize().getStartPoint();
    }

    public Point getEndPoint() {
        return this.linearize().getEndPoint();
    }

    public boolean isRing() {
        return this.linearize().isRing();
    }

    public double getLength() {
        return this.linearize().getLength();
    }

    public Geometry getBoundary() {
        return this.linearize().getBoundary();
    }

    public boolean isCoordinate(Coordinate pt) {
        return this.linearize().isCoordinate(pt);
    }

    public void apply(CoordinateFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(CoordinateSequenceFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(GeometryFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(GeometryComponentFilter filter) {
        this.linearize().apply(filter);
    }

    public CircularRing copyInternal() {
        return new CircularRing(this.getControlPoints(), this.factory, this.getTolerance());
    }

    public void normalize() {
        this.linearize().normalize();
    }

    public boolean isSimple() {
        return this.linearize().isSimple();
    }

    public boolean isValid() {
        return this.linearize().isValid();
    }

    public double distance(Geometry g) {
        return this.linearize().distance(g);
    }

    public boolean isWithinDistance(Geometry geom, double distance) {
        return this.linearize().isWithinDistance(geom, distance);
    }

    public double getArea() {
        return this.linearize().getArea();
    }

    public Point getCentroid() {
        return this.linearize().getCentroid();
    }

    public void geometryChanged() {
        this.linearize().geometryChanged();
    }

    public boolean disjoint(Geometry g) {
        return this.linearize().disjoint(g);
    }

    public boolean touches(Geometry g) {
        return this.linearize().touches(g);
    }

    public boolean intersects(Geometry g) {
        return this.linearize().intersects(g);
    }

    public boolean crosses(Geometry g) {
        return this.linearize().crosses(g);
    }

    public boolean within(Geometry g) {
        return this.linearize().within(g);
    }

    public boolean contains(Geometry g) {
        return this.linearize().contains(g);
    }

    public boolean overlaps(Geometry g) {
        return this.linearize().overlaps(g);
    }

    public boolean covers(Geometry g) {
        return this.linearize().covers(g);
    }

    public boolean coveredBy(Geometry g) {
        return this.linearize().coveredBy(g);
    }

    public boolean relate(Geometry g, String intersectionPattern) {
        return this.linearize().relate(g, intersectionPattern);
    }

    public IntersectionMatrix relate(Geometry g) {
        return this.linearize().relate(g);
    }

    public Geometry buffer(double distance) {
        return this.linearize().buffer(distance);
    }

    public Geometry buffer(double distance, int quadrantSegments) {
        return this.linearize().buffer(distance, quadrantSegments);
    }

    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return this.linearize().buffer(distance, quadrantSegments, endCapStyle);
    }

    public Geometry convexHull() {
        return this.linearize().convexHull();
    }

    public Geometry intersection(Geometry other) {
        return this.linearize().intersection(other);
    }

    public Geometry union(Geometry other) {
        return this.linearize().union(other);
    }

    public Geometry difference(Geometry other) {
        return this.linearize().difference(other);
    }

    public Geometry symDifference(Geometry other) {
        return this.linearize().symDifference(other);
    }

    public Geometry union() {
        return this.linearize().union();
    }

    public Geometry norm() {
        return this.linearize().norm();
    }

    public int compareTo(Object o) {
        return this.linearize().compareTo(o);
    }

    public int compareTo(Object o, CoordinateSequenceComparator comp) {
        return this.linearize().compareTo(o, comp);
    }

    public String toText() {
        return this.linearize().toText();
    }
}

