/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.http.HTTPBehavior;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFactory;
import org.geotools.http.LoggingHTTPClient;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public abstract class AbstractHTTPClientFactory
implements HTTPClientFactory {
    private final Logger LOGGER = Logging.getLogger(AbstractHTTPClientFactory.class);

    @Override
    public final boolean canProcess(Hints hints, List<Class<? extends HTTPBehavior>> behaviors) {
        Object val = hints.get(Hints.HTTP_CLIENT);
        return this.clientClasses().stream().filter(cls -> AbstractHTTPClientFactory.matchClientHint(cls, val)).anyMatch(cls -> behaviors.stream().allMatch(behavior -> behavior.isAssignableFrom((Class<?>)cls)));
    }

    private static boolean matchClientHint(Class<?> cls, Object val) {
        if (val == null) {
            return true;
        }
        if (val instanceof String) {
            String clsName = (String)val;
            return cls.getName().equals(clsName);
        }
        Class cls2 = (Class)val;
        return cls2 == cls;
    }

    protected abstract List<Class<?>> clientClasses();

    @Override
    public abstract HTTPClient createClient(List<Class<? extends HTTPBehavior>> var1);

    @Override
    public final HTTPClient createClient(Hints hints, List<Class<? extends HTTPBehavior>> behaviors) {
        HTTPClient client = this.createClient(behaviors);
        Set missingBehaviors = behaviors.stream().filter(behavior -> !behavior.isInstance(client)).collect(Collectors.toSet());
        if (!missingBehaviors.isEmpty()) {
            throw new RuntimeException(String.format("HTTP client %s doesn't support behaviors: %s", client.getClass().getName(), missingBehaviors.stream().map(behavior -> behavior.getSimpleName()).collect(Collectors.joining(", "))));
        }
        if (hints.containsKey(Hints.HTTP_LOGGING)) {
            return this.applyLogging(client, hints);
        }
        return client;
    }

    protected HTTPClient applyLogging(HTTPClient client, Hints hints) {
        this.LOGGER.fine("Applying logging to HTTP Client.");
        String hint = (String)hints.get(Hints.HTTP_LOGGING);
        Boolean logging = Boolean.parseBoolean(hint);
        if (logging.booleanValue()) {
            return this.createLogging(client);
        }
        if ("false".equalsIgnoreCase(hint)) {
            return client;
        }
        throw new RuntimeException(String.format("HTTP_LOGGING value %s is unknown.", hint));
    }

    protected HTTPClient createLogging(HTTPClient client) {
        return new LoggingHTTPClient(client);
    }
}

