/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.extent;

import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Locale;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.iso.extent.GeographicExtentImpl;
import org.geotools.util.Utilities;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.operation.TransformException;

public class GeographicBoundingBoxImpl
extends GeographicExtentImpl
implements GeographicBoundingBox {
    private static final long serialVersionUID = -3278089380004172514L;
    private static Method constructor;
    private static Method toString;
    public static final GeographicBoundingBox WORLD;
    private double westBoundLongitude;
    private double eastBoundLongitude;
    private double southBoundLatitude;
    private double northBoundLatitude;

    public GeographicBoundingBoxImpl() {
    }

    public GeographicBoundingBoxImpl(GeographicBoundingBox box) {
        this.setBounds(box);
    }

    public GeographicBoundingBoxImpl(Envelope envelope) throws TransformException {
        super(true);
        if (constructor == null) {
            constructor = GeographicBoundingBoxImpl.getMethod("copy", Envelope.class, GeographicBoundingBoxImpl.class);
        }
        try {
            GeographicBoundingBoxImpl.invoke(constructor, envelope, this);
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getTargetException();
            if (cause instanceof TransformException) {
                throw (TransformException)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    public GeographicBoundingBoxImpl(Rectangle2D bounds) {
        this(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
    }

    public GeographicBoundingBoxImpl(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) {
        super(true);
        this.setBounds(westBoundLongitude, eastBoundLongitude, southBoundLatitude, northBoundLatitude);
    }

    @Override
    public double getWestBoundLongitude() {
        return this.westBoundLongitude;
    }

    public void setWestBoundLongitude(double newValue) {
        this.checkWritePermission();
        this.westBoundLongitude = newValue;
    }

    @Override
    public double getEastBoundLongitude() {
        return this.eastBoundLongitude;
    }

    public void setEastBoundLongitude(double newValue) {
        this.checkWritePermission();
        this.eastBoundLongitude = newValue;
    }

    @Override
    public double getSouthBoundLatitude() {
        return this.southBoundLatitude;
    }

    public void setSouthBoundLatitude(double newValue) {
        this.checkWritePermission();
        this.southBoundLatitude = newValue;
    }

    @Override
    public double getNorthBoundLatitude() {
        return this.northBoundLatitude;
    }

    public void setNorthBoundLatitude(double newValue) {
        this.checkWritePermission();
        this.northBoundLatitude = newValue;
    }

    public void setBounds(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) {
        this.checkWritePermission();
        this.westBoundLongitude = westBoundLongitude;
        this.eastBoundLongitude = eastBoundLongitude;
        this.southBoundLatitude = southBoundLatitude;
        this.northBoundLatitude = northBoundLatitude;
    }

    public void setBounds(GeographicBoundingBox box) {
        GeographicBoundingBoxImpl.ensureNonNull("box", box);
        this.setInclusion(box.getInclusion());
        this.setBounds(box.getWestBoundLongitude(), box.getEastBoundLongitude(), box.getSouthBoundLatitude(), box.getNorthBoundLatitude());
    }

    public void add(GeographicBoundingBox box) {
        this.checkWritePermission();
        double xmin = box.getWestBoundLongitude();
        double xmax = box.getEastBoundLongitude();
        double ymin = box.getSouthBoundLatitude();
        double ymax = box.getNorthBoundLatitude();
        Boolean inc1 = this.getInclusion();
        GeographicBoundingBoxImpl.ensureNonNull("inclusion", inc1);
        Boolean inc2 = box.getInclusion();
        GeographicBoundingBoxImpl.ensureNonNull("inclusion", inc2);
        if (inc1.booleanValue() == inc2.booleanValue()) {
            if (xmin < this.westBoundLongitude) {
                this.westBoundLongitude = xmin;
            }
            if (xmax > this.eastBoundLongitude) {
                this.eastBoundLongitude = xmax;
            }
            if (ymin < this.southBoundLatitude) {
                this.southBoundLatitude = ymin;
            }
            if (ymax > this.northBoundLatitude) {
                this.northBoundLatitude = ymax;
            }
        } else {
            if (ymin <= this.southBoundLatitude && ymax >= this.northBoundLatitude) {
                if (xmin > this.westBoundLongitude) {
                    this.westBoundLongitude = xmin;
                }
                if (xmax < this.eastBoundLongitude) {
                    this.eastBoundLongitude = xmax;
                }
            }
            if (xmin <= this.westBoundLongitude && xmax >= this.eastBoundLongitude) {
                if (ymin > this.southBoundLatitude) {
                    this.southBoundLatitude = ymin;
                }
                if (ymax < this.northBoundLatitude) {
                    this.northBoundLatitude = ymax;
                }
            }
        }
    }

    public void intersect(GeographicBoundingBox box) {
        this.checkWritePermission();
        Boolean inc1 = this.getInclusion();
        GeographicBoundingBoxImpl.ensureNonNull("inclusion", inc1);
        Boolean inc2 = box.getInclusion();
        GeographicBoundingBoxImpl.ensureNonNull("inclusion", inc2);
        if (inc1.booleanValue() != inc2.booleanValue()) {
            throw new IllegalArgumentException(Errors.format(57, "box"));
        }
        double xmin = box.getWestBoundLongitude();
        double xmax = box.getEastBoundLongitude();
        double ymin = box.getSouthBoundLatitude();
        double ymax = box.getNorthBoundLatitude();
        if (xmin > this.westBoundLongitude) {
            this.westBoundLongitude = xmin;
        }
        if (xmax < this.eastBoundLongitude) {
            this.eastBoundLongitude = xmax;
        }
        if (ymin > this.southBoundLatitude) {
            this.southBoundLatitude = ymin;
        }
        if (ymax < this.northBoundLatitude) {
            this.northBoundLatitude = ymax;
        }
        if (this.westBoundLongitude > this.eastBoundLongitude) {
            this.westBoundLongitude = this.eastBoundLongitude = 0.5 * (this.westBoundLongitude + this.eastBoundLongitude);
        }
        if (this.southBoundLatitude > this.northBoundLatitude) {
            this.southBoundLatitude = this.northBoundLatitude = 0.5 * (this.southBoundLatitude + this.northBoundLatitude);
        }
    }

    public boolean isEmpty() {
        return !(this.eastBoundLongitude > this.westBoundLongitude) || !(this.northBoundLatitude > this.southBoundLatitude);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(GeographicBoundingBoxImpl.class)) {
            GeographicBoundingBoxImpl that = (GeographicBoundingBoxImpl)object;
            return Utilities.equals(this.getInclusion(), that.getInclusion()) && Double.doubleToLongBits(this.southBoundLatitude) == Double.doubleToLongBits(that.southBoundLatitude) && Double.doubleToLongBits(this.northBoundLatitude) == Double.doubleToLongBits(that.northBoundLatitude) && Double.doubleToLongBits(this.eastBoundLongitude) == Double.doubleToLongBits(that.eastBoundLongitude) && Double.doubleToLongBits(this.westBoundLongitude) == Double.doubleToLongBits(that.westBoundLongitude);
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        if (!this.getClass().equals(GeographicBoundingBoxImpl.class)) {
            return super.hashCode();
        }
        Boolean inclusion = this.getInclusion();
        int code = inclusion != null ? inclusion.hashCode() : 0;
        code += GeographicBoundingBoxImpl.hashCode(this.southBoundLatitude);
        code += GeographicBoundingBoxImpl.hashCode(this.northBoundLatitude);
        code += GeographicBoundingBoxImpl.hashCode(this.eastBoundLongitude);
        return code += GeographicBoundingBoxImpl.hashCode(this.westBoundLongitude);
    }

    private static int hashCode(double value) {
        long code = Double.doubleToLongBits(value);
        return (int)code ^ (int)(code >>> 32);
    }

    @Override
    public String toString() {
        return GeographicBoundingBoxImpl.toString(this, "DD\u00b0MM'SS.s\"", null);
    }

    public static String toString(GeographicBoundingBox box, String pattern, Locale locale) {
        if (toString == null) {
            toString = GeographicBoundingBoxImpl.getMethod("toString", GeographicBoundingBox.class, String.class, Locale.class);
        }
        try {
            return String.valueOf(GeographicBoundingBoxImpl.invoke(toString, box, pattern, locale));
        }
        catch (InvocationTargetException exception) {
            throw new UndeclaredThrowableException(exception.getTargetException());
        }
    }

    private static Method getMethod(String name, Class<?> ... arguments) {
        try {
            return Class.forName("org.geotools.referencing.util.BoundingBoxes").getMethod(name, arguments);
        }
        catch (ClassNotFoundException exception) {
            throw new UnsupportedOperationException(Errors.format(98, "referencing"), exception);
        }
        catch (NoSuchMethodException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private static Object invoke(Method method, Object ... arguments) throws InvocationTargetException {
        try {
            return method.invoke(null, arguments);
        }
        catch (IllegalAccessException exception) {
            throw new AssertionError((Object)exception);
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw exception;
        }
    }

    static {
        GeographicBoundingBoxImpl world = new GeographicBoundingBoxImpl(-180.0, 180.0, -90.0, 90.0);
        world.freeze();
        WORLD = world;
    }
}

