/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.util.NullProgressListener;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.feature.visitor.GroupByVisitorBuilder;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MedianVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.feature.visitor.SumAreaVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.PropertyName;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Aggregate", description="Computes one or more aggregation functions on a feature attribute. Functions include Count, Average, Max, Median, Min, StdDev, and Sum.")
public class AggregateProcess
implements VectorProcess {
    public static Results process(SimpleFeatureCollection features, String aggAttribute, Set<AggregationFunction> functions, Boolean singlePass, ProgressListener progressListener) throws ProcessException, IOException {
        return AggregateProcess.process(features, aggAttribute, functions, null, singlePass, progressListener);
    }

    public static Results process(SimpleFeatureCollection features, String aggAttribute, Set<AggregationFunction> functions, List<String> groupByAttributes, Boolean singlePass, ProgressListener progressListener) throws ProcessException, IOException {
        AggregateProcess process = new AggregateProcess();
        return process.execute(features, aggAttribute, functions, singlePass, groupByAttributes, progressListener);
    }

    public Results execute(SimpleFeatureCollection features, String aggAttribute, Set<AggregationFunction> functions, boolean singlePass, ProgressListener progressListener) throws ProcessException, IOException {
        return this.execute(features, aggAttribute, functions, singlePass, null, progressListener);
    }

    @DescribeResult(name="result", description="Aggregation results (one value for each function computed)")
    public Results execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="aggregationAttribute", min=0, description="Attribute on which to perform aggregation") String aggAttribute, @DescribeParameter(name="function", description="An aggregate function to compute. Functions include Count, Average, Max, Median, Min, StdDev, Sum and SumArea.", collectionType=AggregationFunction.class) Set<AggregationFunction> functions, @DescribeParameter(name="singlePass", description="If True computes all aggregation values in a single pass (this will defeat DBMS-specific optimizations)", defaultValue="false") boolean singlePass, @DescribeParameter(name="groupByAttributes", min=0, description="List of group by attributes", collectionType=String.class) List<String> groupByAttributes, ProgressListener progressListener) throws ProcessException, IOException {
        FeatureCalc calc;
        if (groupByAttributes != null && !groupByAttributes.isEmpty()) {
            return this.handleGroupByVisitor(features, aggAttribute, functions, groupByAttributes, progressListener);
        }
        int attIndex = -1;
        List<AttributeDescriptor> atts = ((SimpleFeatureType)features.getSchema()).getAttributeDescriptors();
        for (int i = 0; i < atts.size(); ++i) {
            if (!atts.get(i).getLocalName().equals(aggAttribute)) continue;
            attIndex = i;
            break;
        }
        if (attIndex == -1) {
            throw new ProcessException("Could not find attribute [" + aggAttribute + "]  the valid values are " + this.attNames(atts));
        }
        if (functions == null) {
            throw new NullPointerException("Aggregate function to call is required");
        }
        ArrayList<AggregationFunction> functionList = new ArrayList<AggregationFunction>(functions);
        ArrayList<FeatureCalc> visitors = new ArrayList<FeatureCalc>();
        for (AggregationFunction function : functionList) {
            if (function == AggregationFunction.Average) {
                calc = new AverageVisitor(attIndex, (SimpleFeatureType)features.getSchema());
            } else if (function == AggregationFunction.Count) {
                calc = new CountVisitor();
            } else if (function == AggregationFunction.Max) {
                calc = new MaxVisitor(attIndex, (SimpleFeatureType)features.getSchema());
            } else if (function == AggregationFunction.Median) {
                calc = new MedianVisitor(attIndex, (SimpleFeatureType)features.getSchema());
            } else if (function == AggregationFunction.Min) {
                calc = new MinVisitor(attIndex, (SimpleFeatureType)features.getSchema());
            } else if (function == AggregationFunction.StdDev) {
                calc = new StandardDeviationVisitor(CommonFactoryFinder.getFilterFactory(null).property(aggAttribute));
            } else if (function == AggregationFunction.Sum) {
                calc = new SumVisitor(attIndex, (SimpleFeatureType)features.getSchema());
            } else if (function == AggregationFunction.SumArea) {
                calc = new SumAreaVisitor(attIndex, (SimpleFeatureType)features.getSchema());
            } else {
                throw new ProcessException("Uknown method " + (Object)((Object)function));
            }
            visitors.add(calc);
        }
        EnumMap<AggregationFunction, Number> results = new EnumMap<AggregationFunction, Number>(AggregationFunction.class);
        if (singlePass) {
            AggregateFeatureCalc calc2 = new AggregateFeatureCalc(visitors);
            features.accepts(calc2, new NullProgressListener());
            List resultList = (List)calc2.getResult().getValue();
            for (int i = 0; i < functionList.size(); ++i) {
                CalcResult result = (CalcResult)resultList.get(i);
                if (result == null) continue;
                results.put((AggregationFunction)((Enum)functionList.get(i)), (Number)result.getValue());
            }
        } else {
            for (int i = 0; i < functionList.size(); ++i) {
                calc = (FeatureCalc)visitors.get(i);
                features.accepts(calc, new NullProgressListener());
                results.put((AggregationFunction)((Enum)functionList.get(i)), (Number)calc.getResult().getValue());
            }
        }
        return new Results(aggAttribute, functions, results);
    }

    private Results handleGroupByVisitor(SimpleFeatureCollection features, String aggAttribute, Set<AggregationFunction> functions, List<String> rawGroupByAttributes, ProgressListener progressListener) throws IOException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        Function<AggregationFunction, GroupByVisitor> builder = function -> new GroupByVisitorBuilder().withAggregateAttribute(function == AggregationFunction.SumArea ? this.getArea2(features, aggAttribute, factory) : this.getProperty(features, aggAttribute, factory)).withAggregateVisitor(function.name()).withGroupByAttributes(rawGroupByAttributes, (SimpleFeatureType)features.getSchema()).withProgressListener(progressListener).build();
        List groupByVisitors = functions.stream().map(builder).collect(Collectors.toList());
        for (GroupByVisitor visitor2 : groupByVisitors) {
            features.accepts(visitor2, progressListener);
        }
        List<Map<List<Object>, Object>> results = groupByVisitors.stream().map(visitor -> this.getListObjectMap((GroupByVisitor)visitor)).collect(Collectors.toList());
        return new Results(aggAttribute, functions, rawGroupByAttributes, this.mergeResults(results, rawGroupByAttributes.size()));
    }

    private PropertyName getProperty(SimpleFeatureCollection features, String aggAttribute, FilterFactory factory) {
        return factory.property(((SimpleFeatureType)features.getSchema()).getDescriptor(aggAttribute).getLocalName());
    }

    private org.opengis.filter.expression.Function getArea2(SimpleFeatureCollection features, String attribute, FilterFactory factory) {
        PropertyName property = factory.property(((SimpleFeatureType)features.getSchema()).getDescriptor(attribute).getLocalName());
        return factory.function("area2", property);
    }

    private Map<List<Object>, Object> getListObjectMap(GroupByVisitor visitor) {
        return visitor.getResult().toMap();
    }

    private List<Object[]> mergeResults(List<Map<List<Object>, Object>> results, int groupByAttributesNumber) {
        ArrayList<Object[]> mergedResults = new ArrayList<Object[]>();
        if (results.isEmpty()) {
            return mergedResults;
        }
        int resultSize = groupByAttributesNumber + results.size();
        for (List<Object> groupByAttributes : results.get(0).keySet()) {
            Object[] mergedResult = Arrays.copyOf(groupByAttributes.toArray(), resultSize);
            for (int i = 0; i < results.size(); ++i) {
                mergedResult[groupByAttributesNumber + i] = results.get(i).get(groupByAttributes);
            }
            mergedResults.add(mergedResult);
        }
        return mergedResults;
    }

    private List<String> attNames(List<AttributeDescriptor> atts) {
        ArrayList<String> result = new ArrayList<String>();
        for (AttributeDescriptor ad : atts) {
            result.add(ad.getLocalName());
        }
        return result;
    }

    public static final class Results {
        Double min;
        Double max;
        Double median;
        Double average;
        Double standardDeviation;
        Double sum;
        Double area;
        Long count;
        String aggregateAttribute;
        Set<AggregationFunction> functions;
        List<String> groupByAttributes;
        List<Object[]> groupByResult;
        EnumMap<AggregationFunction, Number> results;

        public Results(String aggregateAttribute, Set<AggregationFunction> functions, List<String> groupByAttributes, List<Object[]> groupByResult) {
            this.aggregateAttribute = aggregateAttribute;
            this.functions = functions;
            this.groupByAttributes = groupByAttributes;
            this.groupByResult = groupByResult;
        }

        public Results(String aggregateAttribute, Set<AggregationFunction> functions, EnumMap<AggregationFunction, Number> results) {
            this.aggregateAttribute = aggregateAttribute;
            this.functions = functions;
            this.results = results;
            this.min = this.toDouble(results.get((Object)AggregationFunction.Min));
            this.max = this.toDouble(results.get((Object)AggregationFunction.Max));
            this.median = this.toDouble(results.get((Object)AggregationFunction.Median));
            this.average = this.toDouble(results.get((Object)AggregationFunction.Average));
            this.standardDeviation = this.toDouble(results.get((Object)AggregationFunction.StdDev));
            this.sum = this.toDouble(results.get((Object)AggregationFunction.Sum));
            this.area = this.toDouble(results.get((Object)AggregationFunction.SumArea));
            Number nc = results.get((Object)AggregationFunction.Count);
            if (nc != null) {
                this.count = nc.longValue();
            }
        }

        Double toDouble(Number number) {
            if (number == null) {
                return null;
            }
            return number.doubleValue();
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }

        public Double getMedian() {
            return this.median;
        }

        public Double getAverage() {
            return this.average;
        }

        public Double getStandardDeviation() {
            return this.standardDeviation;
        }

        public Double getSum() {
            return this.sum;
        }

        public Double getArea() {
            return this.area;
        }

        public Long getCount() {
            return this.count;
        }

        public String getAggregateAttribute() {
            return this.aggregateAttribute;
        }

        public Set<AggregationFunction> getFunctions() {
            return this.functions;
        }

        public List<String> getGroupByAttributes() {
            return this.groupByAttributes;
        }

        public List<Object[]> getGroupByResult() {
            return this.groupByResult;
        }

        public EnumMap<AggregationFunction, Number> getResults() {
            return this.results;
        }
    }

    static class AggregateFeatureCalc
    implements FeatureCalc {
        List<FeatureCalc> delegates;

        public AggregateFeatureCalc(List<FeatureCalc> delegates) {
            this.delegates = delegates;
        }

        @Override
        public CalcResult getResult() {
            final ArrayList<CalcResult> results = new ArrayList<CalcResult>();
            for (FeatureCalc delegate : this.delegates) {
                results.add(delegate.getResult());
            }
            return new AbstractCalcResult(){

                @Override
                public Object getValue() {
                    return results;
                }
            };
        }

        @Override
        public void visit(Feature feature) {
            for (FeatureCalc delegate : this.delegates) {
                delegate.visit(feature);
            }
        }
    }

    public static enum AggregationFunction {
        Count,
        Average,
        Max,
        Median,
        Min,
        StdDev,
        Sum,
        SumArea;

    }
}

