/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.factory.URI_Parser;
import org.geotools.referencing.factory.URI_Type;
import org.geotools.util.Version;
import org.opengis.referencing.NoSuchAuthorityCodeException;

final class HTTP_URI_Parser
extends URI_Parser {
    private static final String AUTHORITY = "http://www.opengis.net/def";
    private static final String SEPARATOR = "/";
    private static final String BASE_URI = "http://www.opengis.net/def/";
    private static final String UNVERSIONED = "0";

    protected HTTP_URI_Parser(String uri, URI_Type type, String authority, Version version, String code) {
        super(uri, type, authority, version, code);
    }

    public static HTTP_URI_Parser buildParser(String uri) throws NoSuchAuthorityCodeException {
        URI_Type uriType;
        String[] segments;
        int length;
        String uriText = uri.trim();
        if (!(!uriText.regionMatches(true, 0, BASE_URI, 0, length = BASE_URI.length()) || (segments = uriText.substring(length).split(SEPARATOR)).length != 4 || segments[0].isEmpty() || (uriType = URI_Type.get(segments[0])) == null || segments[1].isEmpty() || segments[2].isEmpty() || segments[3].isEmpty())) {
            String uriAuthority = segments[1];
            Version uriVersion = segments[2].equals(UNVERSIONED) ? null : new Version(segments[2]);
            String uriCode = segments[3];
            return new HTTP_URI_Parser(uriText, uriType, uriAuthority, uriVersion, uriCode);
        }
        throw new NoSuchAuthorityCodeException(Errors.format(57, uriText), AUTHORITY, uriText);
    }
}

