/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.util.SuppressFBWarnings;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class Mollweide
extends MapProjection {
    private static final long serialVersionUID = -737778661392950540L;
    private static final int MAX_ITER = 10;
    private static final double LOOP_TOL = 1.0E-7;
    double C_x;
    double C_y;
    double C_p;
    ParameterDescriptorGroup descriptors;

    protected Mollweide(ProjectionMode mode, ParameterDescriptorGroup descriptors, ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters, descriptors.descriptors());
        this.descriptors = descriptors;
        if (mode == ProjectionMode.WagnerV) {
            this.C_x = 0.90977;
            this.C_y = 1.65014;
            this.C_p = 3.00896;
        } else {
            double p = mode == ProjectionMode.Mollweide ? 1.5707963267948966 : 1.0471975511965976;
            double p2 = p + p;
            double sp = Math.sin(p);
            double r = Math.sqrt(Math.PI * 2 * sp / (p2 + Math.sin(p2)));
            this.C_x = 2.0 * r / Math.PI;
            this.C_y = r / sp;
            this.C_p = p2 + Math.sin(p2);
        }
    }

    @Override
    @SuppressFBWarnings(value={"UR_UNINIT_READ_CALLED_FROM_SUPER_CONSTRUCTOR"})
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.descriptors;
    }

    @Override
    protected Point2D transformNormalized(double lam, double phi, Point2D ptDst) throws ProjectionException {
        int i;
        double k = this.C_p * Math.sin(phi);
        for (i = 10; i > 0; --i) {
            double V = (phi + Math.sin(phi) - k) / (1.0 + Math.cos(phi));
            phi -= V;
            if (Math.abs(V) < 1.0E-7) break;
        }
        phi = i == 0 ? (phi < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : (phi *= 0.5);
        if (ptDst == null) {
            ptDst = new Point2D.Double();
        }
        ptDst.setLocation(this.C_x * lam * Math.cos(phi), this.C_y * Math.sin(phi));
        return ptDst;
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi = this.aasin(y / this.C_y);
        double lam = x / (this.C_x * Math.cos(phi));
        phi += phi;
        phi = this.aasin((phi + Math.sin(phi)) / this.C_p);
        lam = Mollweide.rollLongitude(lam);
        if (ptDst == null) {
            ptDst = new Point2D.Double();
        }
        ptDst.setLocation(lam, phi);
        return ptDst;
    }

    @Override
    protected double getToleranceForAssertions(double longitude, double latitude) {
        return 2.0;
    }

    public static class WagnerVProvider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -3583284443974045930L;
        static final ParameterDescriptorGroup PARAMETERS = WagnerVProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "Wagner_V")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN});

        public WagnerVProvider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            parameters.parameter("semi_minor").setValue(parameters.parameter("semi_major").getValue());
            return new Mollweide(ProjectionMode.WagnerV, PARAMETERS, parameters);
        }
    }

    public static class WagnerIVProvider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 1079407274370647753L;
        static final ParameterDescriptorGroup PARAMETERS = WagnerIVProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "Wagner_IV")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN});

        public WagnerIVProvider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            parameters.parameter("semi_minor").setValue(parameters.parameter("semi_major").getValue());
            return new Mollweide(ProjectionMode.WagnerIV, PARAMETERS, parameters);
        }
    }

    public static class MollweideProvider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -2616680275771881688L;
        static final ParameterDescriptorGroup PARAMETERS = MollweideProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "Mollweide"), new NamedIdentifier(Citations.ESRI, "Mollweide")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, FALSE_EASTING, FALSE_NORTHING, CENTRAL_MERIDIAN});

        public MollweideProvider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            parameters.parameter("semi_minor").setValue(parameters.parameter("semi_major").getValue());
            return new Mollweide(ProjectionMode.Mollweide, PARAMETERS, parameters);
        }
    }

    static enum ProjectionMode {
        Mollweide,
        WagnerIV,
        WagnerV;

    }
}

