/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils;

import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.ImageLayout;

public class ImageLayout2
extends ImageLayout {
    private static final long serialVersionUID = -7921590012423277029L;

    public ImageLayout2() {
    }

    public ImageLayout2(int minX, int minY, int width, int height, int tileGridXOffset, int tileGridYOffset, int tileWidth, int tileHeight, SampleModel sampleModel, ColorModel colorModel) {
        super(minX, minY, width, height, tileGridXOffset, tileGridYOffset, tileWidth, tileHeight, sampleModel, colorModel);
    }

    public ImageLayout2(int tileGridXOffset, int tileGridYOffset, int tileWidth, int tileHeight, SampleModel sampleModel, ColorModel colorModel) {
        super(tileGridXOffset, tileGridYOffset, tileWidth, tileHeight, sampleModel, colorModel);
    }

    public ImageLayout2(int minX, int minY, int width, int height) {
        super(minX, minY, width, height);
    }

    public ImageLayout2(RenderedImage im) {
        super(im);
    }

    @Override
    public int hashCode() {
        int code = 0;
        int i = 1;
        if (this.isValid(4)) {
            code += this.getWidth(null) * i++;
        }
        if (this.isValid(8)) {
            code += this.getHeight(null) * i++;
        }
        if (this.isValid(1)) {
            code += this.getMinX(null) * i++;
        }
        if (this.isValid(2)) {
            code += this.getMinY(null) * i++;
        }
        if (this.isValid(128)) {
            code += this.getTileHeight(null) * i++;
        }
        if (this.isValid(64)) {
            code += this.getTileWidth(null) * i++;
        }
        if (this.isValid(16)) {
            code += this.getTileGridXOffset(null) * i++;
        }
        if (this.isValid(32)) {
            code += this.getTileGridYOffset(null) * i++;
        }
        if (this.isValid(256)) {
            code ^= this.getSampleModel(null).hashCode();
        }
        code ^= this.validMask;
        if (this.isValid(512)) {
            code ^= this.getColorModel(null).hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!ImageLayout.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ImageLayout other = (ImageLayout)obj;
        if (this.getValidMask() != other.getValidMask()) {
            return false;
        }
        if (this.getWidth(null) != other.getWidth(null)) {
            return false;
        }
        if (this.getHeight(null) != other.getHeight(null)) {
            return false;
        }
        if (this.getMinX(null) != other.getMinX(null)) {
            return false;
        }
        if (this.getMinY(null) != other.getMinY(null)) {
            return false;
        }
        if (this.getTileWidth(null) != other.getTileWidth(null)) {
            return false;
        }
        if (this.getTileHeight(null) != other.getTileHeight(null)) {
            return false;
        }
        if (this.getTileGridXOffset(null) != other.getTileGridXOffset(null)) {
            return false;
        }
        if (this.getTileGridYOffset(null) != other.getTileGridYOffset(null)) {
            return false;
        }
        SampleModel sm = this.getSampleModel(null);
        if (sm == null ? other.getSampleModel(null) != null : !sm.equals(other.getSampleModel(null))) {
            return false;
        }
        ColorModel cm = this.getColorModel(null);
        return !(cm == null ? other.getColorModel(null) != null : !cm.equals(other.getColorModel(null)));
    }
}

