/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.util.Objects;
import javax.measure.UnitConverter;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.internal.function.calc.Calculator;

final class DoubleMultiplyConverter
extends AbstractConverter
implements MultiplyConverter {
    private static final long serialVersionUID = 6588759878444545649L;
    private final double doubleFactor;

    private DoubleMultiplyConverter(double factor) {
        this.doubleFactor = factor;
    }

    static DoubleMultiplyConverter of(double factor) {
        return new DoubleMultiplyConverter(factor);
    }

    @Override
    public boolean isIdentity() {
        return this.doubleFactor == 1.0;
    }

    @Override
    protected boolean canReduceWith(AbstractConverter that) {
        return that instanceof DoubleMultiplyConverter;
    }

    @Override
    protected AbstractConverter reduce(AbstractConverter that) {
        return new DoubleMultiplyConverter(this.doubleFactor * ((DoubleMultiplyConverter)that).doubleFactor);
    }

    @Override
    public DoubleMultiplyConverter inverseWhenNotIdentity() {
        return new DoubleMultiplyConverter(1.0 / this.doubleFactor);
    }

    @Override
    protected Number convertWhenNotIdentity(Number value) {
        return Calculator.of(this.doubleFactor).multiply(value).peek();
    }

    @Override
    public final String transformationLiteral() {
        return String.format("x -> x * %s", this.doubleFactor);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DoubleMultiplyConverter) {
            DoubleMultiplyConverter that = (DoubleMultiplyConverter)obj;
            return Objects.equals(this.doubleFactor, that.doubleFactor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.doubleFactor);
    }

    @Override
    public Double getValue() {
        return this.doubleFactor;
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof DoubleMultiplyConverter) {
            return this.getValue().compareTo(((DoubleMultiplyConverter)o).getValue());
        }
        return -1;
    }
}

