/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.ClippedFeatureCollection;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.spatial.BBOX;

@DescribeProcess(title="Clip", description="Clips (crops) features to a given geometry")
public class ClipProcess
implements VectorProcess {
    static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints());

    @DescribeResult(name="result", description="Clipped feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="clip", description="Geometry to use for clipping (in same CRS as input features)") Geometry clip, @DescribeParameter(name="preserveZ", min=0, description="Attempt to preserve Z values from the original geometry (interpolate value for new points)") Boolean preserveZ) throws ProcessException {
        Envelope box = clip.getEnvelopeInternal();
        String srs = null;
        if (((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem() != null) {
            srs = CRS.toSRS(((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem());
        }
        BBOX bboxFilter = ff.bbox("", box.getMinX(), box.getMinY(), box.getMaxX(), box.getMaxY(), srs);
        if (preserveZ == null) {
            preserveZ = false;
        }
        return new ClippedFeatureCollection(features.subCollection(bboxFilter), clip, preserveZ);
    }
}

