/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.io.IOException;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.GeometryCollector;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Collect Geometries", description="Collects the default geometries of the input features and combines them into a single geometry collection")
public class CollectGeometries
implements VectorProcess {
    @DescribeResult(name="result", description="Geometry collection of all input geometries")
    public GeometryCollection execute(@DescribeParameter(name="features", description="Input feature collection") FeatureCollection features, ProgressListener progressListener) throws IOException {
        int count = features.size();
        float done = 0.0f;
        GeometryCollector collector = new GeometryCollector();
        try (FeatureIterator fi = features.features();){
            while (fi.hasNext()) {
                Geometry g = (Geometry)fi.next().getDefaultGeometryProperty().getValue();
                collector.add(g);
                if (progressListener == null || (done += 1.0f) % 100.0f != 0.0f) continue;
                progressListener.progress(done / (float)count);
            }
        }
        return collector.collect();
    }
}

