/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.temporal.object.DefaultPeriodDuration;
import org.geotools.temporal.object.DefaultTemporalPosition;
import org.geotools.temporal.object.DefaultTemporalPrimitive;
import org.opengis.temporal.Duration;
import org.opengis.temporal.Instant;
import org.opengis.temporal.OrdinalReferenceSystem;
import org.opengis.temporal.Period;
import org.opengis.temporal.RelativePosition;
import org.opengis.temporal.Separation;
import org.opengis.temporal.TemporalGeometricPrimitive;

public abstract class DefaultTemporalGeometricPrimitive
extends DefaultTemporalPrimitive
implements TemporalGeometricPrimitive,
Separation {
    @Override
    public Duration distance(TemporalGeometricPrimitive other) {
        long diff = 0L;
        if (this instanceof Instant && other instanceof Instant) {
            if (((Instant)((Object)this)).getPosition().anyOther() != null && ((Instant)other).getPosition().anyOther() != null) {
                if (!((DefaultTemporalPosition)((Instant)((Object)this)).getPosition().anyOther()).getFrame().equals(((DefaultTemporalPosition)((Instant)other).getPosition().anyOther()).getFrame())) {
                    try {
                        throw new Exception("the TM_TemporalPositions are not both associated with the same TM_ReferenceSystem !");
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DefaultTemporalGeometricPrimitive.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else if (((Instant)((Object)this)).getPosition().anyOther() != null) {
                if (((Instant)((Object)this)).getPosition().anyOther().getIndeterminatePosition() != null || ((DefaultTemporalPosition)((Instant)((Object)this)).getPosition().anyOther()).getFrame() instanceof OrdinalReferenceSystem) {
                    try {
                        throw new Exception("either of the two TM_TemporalPositions is indeterminate or is associated with a TM_OrdianlReferenceSystem !");
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DefaultTemporalGeometricPrimitive.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else if (((Instant)other).getPosition().anyOther() != null && (((Instant)other).getPosition().anyOther().getIndeterminatePosition() != null || ((DefaultTemporalPosition)((Instant)other).getPosition().anyOther()).getFrame() instanceof OrdinalReferenceSystem)) {
                try {
                    throw new Exception("either of the two TM_TemporalPositions is indeterminate or is associated with a TM_OrdianlReferenceSystem !");
                }
                catch (Exception ex) {
                    Logger.getLogger(DefaultTemporalGeometricPrimitive.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (this.relativePosition(other).equals(RelativePosition.BEFORE) || this.relativePosition(other).equals(RelativePosition.AFTER)) {
            if (this instanceof Instant && other instanceof Instant) {
                diff = Math.min(Math.abs(this.iTime((Instant)other) - this.iTime((Instant)((Object)this))), Math.abs(this.iTime((Instant)((Object)this)) - this.iTime((Instant)other)));
            } else if (this instanceof Instant && other instanceof Period) {
                diff = Math.min(Math.abs(this.pbTime((Period)other) - this.iTime((Instant)((Object)this))), Math.abs(this.iTime(((Period)other).getEnding()) - this.iTime((Instant)((Object)this))));
            } else if (this instanceof Period && other instanceof Instant) {
                diff = Math.min(Math.abs(this.iTime((Instant)other) - this.iTime(((Period)((Object)this)).getEnding())), Math.abs(this.iTime((Instant)other) - this.pbTime((Period)((Object)this))));
            } else if (this instanceof Period && other instanceof Period) {
                diff = Math.min(Math.abs(this.peTime((Period)other) - this.pbTime((Period)((Object)this))), Math.abs(this.pbTime((Period)other) - this.peTime((Period)((Object)this))));
            }
        } else if (this.relativePosition(other).equals(RelativePosition.BEGINS) || this.relativePosition(other).equals(RelativePosition.BEGUN_BY) || this.relativePosition(other).equals(RelativePosition.CONTAINS) || this.relativePosition(other).equals(RelativePosition.DURING) || this.relativePosition(other).equals(RelativePosition.ENDED_BY) || this.relativePosition(other).equals(RelativePosition.ENDS) || this.relativePosition(other).equals(RelativePosition.EQUALS) || this.relativePosition(other).equals(RelativePosition.MEETS) || this.relativePosition(other).equals(RelativePosition.MET_BY) || this.relativePosition(other).equals(RelativePosition.OVERLAPPED_BY) || this.relativePosition(other).equals(RelativePosition.OVERLAPS)) {
            diff = 0L;
        }
        DefaultPeriodDuration response = new DefaultPeriodDuration(Math.abs(diff));
        return response;
    }

    private long iTime(Instant instant) {
        return instant.getPosition().getDate().getTime();
    }

    private long peTime(Period other) {
        return this.iTime(other.getEnding());
    }

    private long pbTime(Period other) {
        return this.iTime(other.getBeginning());
    }

    @Override
    public Duration length() {
        Duration response = null;
        long diff = 0L;
        if (this instanceof Instant) {
            response = new DefaultPeriodDuration(Math.abs(diff));
            return response;
        }
        if (this instanceof Period && ((Period)((Object)this)).getBeginning() != null && ((Period)((Object)this)).getEnding() != null) {
            response = ((Period)((Object)this)).getBeginning().distance(((Period)((Object)this)).getEnding());
            return response;
        }
        return null;
    }
}

