/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.aws.ec2;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.InstanceStateChange;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesResult;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.deeplearning4j.aws.s3.BaseS3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ec2BoxCreator
extends BaseS3 {
    private String amiId;
    private int numBoxes;
    private String size;
    private List<String> boxesCreated;
    private String securityGroupId;
    private String keyPair;
    private Regions regions = Regions.DEFAULT_REGION;
    private static Logger log = LoggerFactory.getLogger(Ec2BoxCreator.class);
    public static final String DEFAULT_AMI = "ami-8997afe0";

    public Ec2BoxCreator(int numBoxes, String size, String securityGroupId, String keyPair) {
        this(DEFAULT_AMI, numBoxes, size, securityGroupId, keyPair);
    }

    public Ec2BoxCreator(String amiId, int numBoxes, String size, String securityGroupId, String keyPair) {
        this.amiId = amiId;
        this.numBoxes = numBoxes;
        this.size = size;
        this.keyPair = keyPair;
        this.securityGroupId = securityGroupId;
    }

    public void createSpot() {
        RequestSpotInstancesRequest requestRequest = new RequestSpotInstancesRequest();
        requestRequest.setSpotPrice("0.03");
        requestRequest.setInstanceCount(Integer.valueOf(1));
        LaunchSpecification launchSpecification = new LaunchSpecification();
        launchSpecification.setImageId("ami-8c1fece5");
        launchSpecification.setInstanceType("t1.micro");
        ArrayList<String> securityGroups = new ArrayList<String>();
        securityGroups.add("GettingStartedGroup");
        launchSpecification.setSecurityGroups(securityGroups);
        requestRequest.setLaunchSpecification(launchSpecification);
        RequestSpotInstancesResult requestResult = this.getEc2().requestSpotInstances(requestRequest);
        List requestResponses = requestResult.getSpotInstanceRequests();
        ArrayList<String> spotInstanceRequestIds = new ArrayList<String>();
        for (SpotInstanceRequest requestResponse : requestResponses) {
            System.out.println("Created Spot Request: " + requestResponse.getSpotInstanceRequestId());
            spotInstanceRequestIds.add(requestResponse.getSpotInstanceRequestId());
        }
    }

    public void setRegion(Regions regions) {
        this.regions = regions;
    }

    public void create() {
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest().withImageId(this.amiId).withInstanceType(this.size).withKeyName(this.keyPair).withMinCount(Integer.valueOf(1)).withSecurityGroupIds(new String[]{this.securityGroupId}).withMaxCount(Integer.valueOf(this.numBoxes));
        AmazonEC2 ec2 = this.getEc2();
        ec2.setRegion(Region.getRegion((Regions)this.regions));
        List boxes = ec2.runInstances(runInstancesRequest).getReservation().getInstances();
        if (this.boxesCreated == null) {
            this.boxesCreated = new ArrayList<String>();
            for (Instance i : boxes) {
                this.boxesCreated.add(i.getInstanceId());
            }
            log.info("Boxes created " + this.boxesCreated);
        } else {
            this.blowupBoxes();
            this.boxesCreated.clear();
            for (Instance i : boxes) {
                this.boxesCreated.add(i.getInstanceId());
            }
        }
    }

    public List<InstanceStateChange> blowupBoxes() {
        TerminateInstancesRequest request = new TerminateInstancesRequest().withInstanceIds(this.boxesCreated);
        if (this.boxesCreated != null) {
            TerminateInstancesResult result = this.getEc2().terminateInstances(request);
            List change = result.getTerminatingInstances();
            log.info("Boxes destroyed " + this.boxesCreated);
            return change;
        }
        return Collections.emptyList();
    }

    public void blockTillAllRunning() {
        while (!this.allRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            log.info("Not all created...");
        }
    }

    public boolean allRunning() {
        if (this.boxesCreated == null) {
            return false;
        }
        DescribeInstancesResult result = this.getEc2().describeInstances();
        List reservations = result.getReservations();
        for (Reservation r : reservations) {
            List instances = r.getInstances();
            for (Instance instance : instances) {
                InstanceState state = instance.getState();
                if (state.getCode() == 48 || state.getCode() == 16) continue;
                return false;
            }
        }
        return true;
    }

    public List<String> getHosts() {
        DescribeInstancesResult result = this.getEc2().describeInstances();
        ArrayList<String> hosts = new ArrayList<String>();
        List reservations = result.getReservations();
        for (Reservation r : reservations) {
            List instances = r.getInstances();
            for (Instance instance : instances) {
                InstanceState state = instance.getState();
                if (state.getCode() == 48) continue;
                hosts.add(instance.getPublicDnsName());
            }
        }
        return hosts;
    }

    public List<String> getBoxesCreated() {
        return this.boxesCreated;
    }
}

