/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.aws.ec2.provision;

import akka.actor.ActorSystem;
import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import com.amazonaws.regions.Regions;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.Callable;
import org.deeplearning4j.aws.ec2.Ec2BoxCreator;
import org.deeplearning4j.aws.ec2.provision.HostProvisioner;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class ClusterSetup {
    @Option(name="-w", usage="Number of workers")
    private int numWorkers = 1;
    @Option(name="-ami", usage="Amazon machine image: default, amazon linux (only works with RHEL right now")
    private String ami = "ami-fb8e9292";
    @Option(name="-s", usage="size of instance: default m1.medium")
    private String size = "m3.xlarge";
    @Option(name="-sg", usage="security group, this needs to be applyTransformToDestination")
    private String securityGroupName;
    @Option(name="-kp", usage="key pair name, also needs to be applyTransformToDestination.")
    private String keyPairName;
    @Option(name="-kpath", usage="path to private key - needs to be applyTransformToDestination, this is used to login to amazon.")
    private String pathToPrivateKey;
    @Option(name="-wscript", usage="path to worker script to run, this will allow customization of dependencies")
    private String workerSetupScriptPath;
    @Option(name="-mscript", usage="path to master script to run this will allow customization of the dependencies")
    private String masterSetupScriptPath;
    @Option(name="-region", usage="specify a region")
    private String region = Regions.US_EAST_1.getName();
    private ActorSystem as;
    private static Logger log = LoggerFactory.getLogger(ClusterSetup.class);

    public ClusterSetup(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            parser.printUsage((OutputStream)System.err);
            log.error("Unable to parse args", (Throwable)e);
        }
    }

    public void exec() {
        Ec2BoxCreator boxCreator = new Ec2BoxCreator(this.ami, this.numWorkers, this.size, this.securityGroupName, this.keyPairName);
        boxCreator.setRegion(Regions.fromName((String)this.region));
        boxCreator.create();
        boxCreator.blockTillAllRunning();
        List<String> hosts = boxCreator.getHosts();
        this.provisionWorkers(hosts);
    }

    private void provisionWorkers(List<String> workers) {
        this.as = ActorSystem.create((String)"Workers");
        for (final String workerHost : workers) {
            try {
                Future f = Futures.future((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        HostProvisioner uploader = new HostProvisioner(workerHost, "ec2-user");
                        uploader.addKeyFile(ClusterSetup.this.pathToPrivateKey);
                        uploader.uploadAndRun(ClusterSetup.this.workerSetupScriptPath, "");
                        return null;
                    }
                }, (ExecutionContext)this.as.dispatcher());
                f.onComplete((Function1)new OnComplete<Void>(){

                    public void onComplete(Throwable throwable, Void aVoid) throws Throwable {
                        if (throwable != null) {
                            throw throwable;
                        }
                    }
                }, (ExecutionContext)this.as.dispatcher());
            }
            catch (Exception e) {
                log.error("Error ", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        new ClusterSetup(args).exec();
    }
}

