/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.aws.ec2.provision;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostProvisioner
implements UserInfo {
    private String host;
    private JSch jsch;
    private String user;
    private int port = 22;
    private String password;
    private static Logger log = LoggerFactory.getLogger(HostProvisioner.class);

    public HostProvisioner(String host, String user, String password, int port) {
        this.host = host;
        this.user = user;
        this.port = port;
        this.password = password;
        this.jsch = new JSch();
    }

    public HostProvisioner(String host, String user, String password) {
        this(host, user, password, 22);
    }

    public HostProvisioner(String host, String user) {
        this(host, user, "", 22);
    }

    public HostProvisioner(String host) {
        this(host, "root", "", 22);
    }

    public void uploadAndRun(String script, String rootDir) throws Exception {
        String remoteName = rootDir.isEmpty() ? new File(script).getName() : rootDir + "/" + script;
        this.upload(new File(script), remoteName);
        String remoteCommand = remoteName.charAt(0) != '/' ? "./" + remoteName : remoteName;
        remoteCommand = "chmod +x " + remoteCommand + " && " + remoteCommand;
        this.runRemoteCommand(remoteCommand);
    }

    public void runRemoteCommand(String remoteCommand) throws Exception {
        Session session = this.getSession();
        session.connect();
        ChannelExec channel = (ChannelExec)session.openChannel("exec");
        channel.setCommand(remoteCommand);
        channel.setErrStream((OutputStream)System.err);
        channel.setPty(true);
        channel.setOutputStream((OutputStream)System.out);
        channel.connect();
        channel.start();
        InputStream input = channel.getInputStream();
        byte[] tmp = new byte[1024];
        while (true) {
            int i;
            if (input.available() > 0 && (i = input.read(tmp, 0, 1024)) >= 0) {
                log.info(new String(tmp, 0, i));
                continue;
            }
            if (channel.isClosed()) break;
            Thread.sleep(1000L);
        }
        log.info("exit-status: " + channel.getExitStatus());
        channel.disconnect();
        session.disconnect();
    }

    private Session getSession() throws Exception {
        Session session = this.jsch.getSession(this.user, this.host, this.port);
        session.setUserInfo((UserInfo)this);
        return session;
    }

    public void uploadForDeployment(String from, String to) throws Exception {
        File fromFile = new File(from);
        if (!to.isEmpty() && fromFile.isDirectory()) {
            this.mkDir(to);
        } else {
            this.upload(from, to);
        }
    }

    public void addKeyFile(String keyFile) throws Exception {
        this.jsch.addIdentity(keyFile);
    }

    private void mkDir(String dir) throws Exception {
        Session session = this.getSession();
        session.connect();
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp c = (ChannelSftp)channel;
        if (!this.fileExists(dir, c)) {
            c.mkdir(dir);
        }
        c.exit();
        session.disconnect();
    }

    private boolean fileExists(String dir, ChannelSftp channel) {
        try {
            channel.stat(dir);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void upload(String fileOrDir, String uploadRootDir) throws Exception {
        if (uploadRootDir.isEmpty()) {
            uploadRootDir = ".";
        }
        File origin = new File(fileOrDir);
        if (fileOrDir.endsWith(".tar") || fileOrDir.endsWith(".tar.gz")) {
            this.upload(new File(fileOrDir), uploadRootDir);
            this.untar(uploadRootDir);
        } else if (origin.isFile()) {
            this.upload(new File(fileOrDir), uploadRootDir);
        } else {
            File[] childFiles = origin.listFiles();
            if (childFiles != null) {
                this.upload(Arrays.asList(childFiles), uploadRootDir);
            }
        }
    }

    private void untar(String targetRemoteFile) throws Exception {
        this.runRemoteCommand("tar xvf " + targetRemoteFile);
    }

    private void upload(Collection<File> files, String rootDir) throws Exception {
        Session session = this.getSession();
        session.connect();
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp c = (ChannelSftp)channel;
        for (File f : files) {
            if (f.isDirectory()) {
                log.warn("Skipping " + f.getName());
                continue;
            }
            log.info("Uploading " + f.getName());
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            c.put((InputStream)bis, rootDir + "/" + f.getName());
            bis.close();
        }
        channel.disconnect();
        session.disconnect();
    }

    private void upload(File f, String remoteFile) throws Exception {
        Session session = this.getSession();
        int numRetries = 0;
        while (numRetries < 3 && !session.isConnected()) {
            try {
                session.connect();
            }
            catch (Exception e) {
                ++numRetries;
            }
        }
        try {
            Channel channel = session.openChannel("sftp");
            channel.connect();
            ChannelSftp c = (ChannelSftp)channel;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            if (this.fileExists(remoteFile, c)) {
                if (f.isDirectory()) {
                    c.rmdir(remoteFile);
                } else {
                    c.rm(remoteFile);
                }
            }
            c.put((InputStream)bis, remoteFile);
            bis.close();
            c.exit();
            session.disconnect();
        }
        catch (Exception e) {
            log.info("Session was down...trying again");
            this.upload(f, remoteFile);
        }
    }

    public String getPassphrase() {
        return this.password;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean promptPassphrase(String arg0) {
        return true;
    }

    public boolean promptPassword(String arg0) {
        return true;
    }

    public boolean promptYesNo(String arg0) {
        return true;
    }

    public void showMessage(String arg0) {
        log.info(arg0);
    }
}

