/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.aws.s3.reader;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.aws.s3.BaseS3;
import org.deeplearning4j.aws.s3.reader.BucketIterator;
import org.deeplearning4j.aws.s3.reader.BucketKeyListener;

public class S3Downloader
extends BaseS3 {
    public List<String> buckets() {
        ArrayList<String> ret = new ArrayList<String>();
        AmazonS3 s3 = this.getClient();
        List buckets = s3.listBuckets();
        for (Bucket b : buckets) {
            ret.add(b.getName());
        }
        return ret;
    }

    public Iterator<InputStream> iterateBucket(String bucket) {
        return new BucketIterator(bucket, this);
    }

    public ObjectListing nextList(ObjectListing list) {
        AmazonS3 s3 = this.getClient();
        if (list.isTruncated()) {
            return s3.listNextBatchOfObjects(list);
        }
        return null;
    }

    public ObjectListing listObjects(String bucket) {
        AmazonS3 s3 = this.getClient();
        ObjectListing list = s3.listObjects(bucket);
        return list;
    }

    public void paginate(String bucket, BucketKeyListener listener) {
        AmazonS3 s3 = this.getClient();
        ObjectListing list = s3.listObjects(bucket);
        for (S3ObjectSummary summary : list.getObjectSummaries()) {
            if (listener == null) continue;
            listener.onKey(s3, bucket, summary.getKey());
        }
        while (list.isTruncated()) {
            list = s3.listNextBatchOfObjects(list);
            for (S3ObjectSummary summary : list.getObjectSummaries()) {
                if (listener == null) continue;
                listener.onKey(s3, bucket, summary.getKey());
            }
        }
    }

    public InputStream objectForKey(String bucket, String key) {
        AmazonS3 s3 = this.getClient();
        S3Object obj = s3.getObject(bucket, key);
        S3ObjectInputStream is = obj.getObjectContent();
        return is;
    }

    public void download(String bucket, String key, File to) throws IOException {
        AmazonS3 s3 = this.getClient();
        S3Object obj = s3.getObject(bucket, key);
        S3ObjectInputStream is = obj.getObjectContent();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(to));
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        bos.close();
        is.close();
        obj.close();
    }

    public void download(String bucket, String key, OutputStream to) throws IOException {
        AmazonS3 s3 = this.getClient();
        S3Object obj = s3.getObject(bucket, key);
        S3ObjectInputStream is = obj.getObjectContent();
        BufferedOutputStream bos = new BufferedOutputStream(to);
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        bos.close();
        is.close();
        obj.close();
    }
}

