/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.aws.s3.uploader;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.deeplearning4j.aws.s3.BaseS3;

public class S3Uploader
extends BaseS3 {
    public void upload(File file, String bucketName) {
        AmazonS3Client client = new AmazonS3Client(this.creds);
        bucketName = this.ensureValidBucketName(bucketName);
        List buckets = client.listBuckets();
        for (Bucket b : buckets) {
            if (!b.getName().equals(bucketName)) continue;
            client.putObject(bucketName, file.getName(), file);
            return;
        }
        client.createBucket(bucketName);
        client.putObject(bucketName, file.getName(), file);
    }

    private String ensureValidBucketName(String bucketName) {
        String formatted = bucketName.replaceAll("\\s+", "_");
        int length = bucketName.length();
        if (length >= 62) {
            length = 62;
        }
        formatted = formatted.substring(0, length);
        formatted = formatted.replace(".", "d");
        if ((formatted = formatted.toLowerCase()).endsWith("-")) {
            formatted = formatted.substring(0, length - 1);
        }
        return formatted;
    }

    public void upload(InputStream is, String name, String bucketName) {
        AmazonS3 client = this.getClient();
        bucketName = this.ensureValidBucketName(bucketName);
        List buckets = client.listBuckets();
        ObjectMetadata med = new ObjectMetadata();
        for (Bucket b : buckets) {
            if (!b.getName().equals(bucketName)) continue;
            client.putObject(bucketName, name, is, med);
            return;
        }
        client.createBucket(bucketName);
        client.putObject(bucketName, name, is, med);
    }
}

