/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.aws.s3.reader;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.deeplearning4j.aws.s3.reader.S3Downloader;
import org.deeplearning4j.datasets.iterator.DataSetIterator;

public abstract class BaseS3DataSetIterator
implements DataSetIterator {
    private static final long serialVersionUID = 885205002006822431L;
    private S3Downloader downloader = new S3Downloader();
    private List<String> buckets = this.downloader.buckets();
    private int currBucket = 0;
    private Iterator<InputStream> currIterator = this.downloader.iterateBucket(this.buckets.get(this.currBucket));

    public InputStream nextObject() {
        if (this.currIterator.hasNext()) {
            return this.currIterator.next();
        }
        if (this.currBucket < this.buckets.size()) {
            ++this.currBucket;
            this.currIterator = this.downloader.iterateBucket(this.buckets.get(this.currBucket));
            return this.currIterator.next();
        }
        return null;
    }

    public boolean hasNext() {
        return this.currBucket < this.buckets.size() && this.currIterator.hasNext();
    }

    public String currBucket() {
        return this.buckets.get(this.currBucket);
    }

    public void nextBucket() {
        ++this.currBucket;
    }
}

