/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.aws.s3.reader;

import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.deeplearning4j.aws.s3.reader.S3Downloader;

public class BucketIterator
implements Iterator<InputStream> {
    private S3Downloader s3;
    private String bucket;
    private ObjectListing currList;
    private List<S3ObjectSummary> currObjects;
    private int currObject;

    public BucketIterator(String bucket) {
        this(bucket, null);
    }

    public BucketIterator(String bucket, S3Downloader s3) {
        this.bucket = bucket;
        this.s3 = s3 == null ? new S3Downloader() : s3;
        this.currList = s3.listObjects(bucket);
        this.currObjects = this.currList.getObjectSummaries();
    }

    @Override
    public boolean hasNext() {
        return this.currObject < this.currObjects.size();
    }

    @Override
    public InputStream next() {
        if (this.currObject < this.currObjects.size()) {
            InputStream ret = this.s3.objectForKey(this.bucket, this.currObjects.get(this.currObject).getKey());
            ++this.currObject;
            return ret;
        }
        if (this.currList.isTruncated()) {
            this.currList = this.s3.nextList(this.currList);
            this.currObjects = this.currList.getObjectSummaries();
            this.currObject = 0;
            InputStream ret = this.s3.objectForKey(this.bucket, this.currObjects.get(this.currObject).getKey());
            ++this.currObject;
            return ret;
        }
        throw new IllegalStateException("Indeterminate state");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

