/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.aws.s3.modelsaver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.UUID;
import org.deeplearning4j.aws.s3.BaseS3;
import org.deeplearning4j.aws.s3.uploader.S3Uploader;
import org.deeplearning4j.scaleout.actor.core.ModelSaver;

public class S3ModelSaver
extends BaseS3
implements ModelSaver {
    private static final long serialVersionUID = -3922672528784966211L;
    private String bucketName;

    public S3ModelSaver(String bucketName) {
        this.bucketName = bucketName;
    }

    public void save(Serializable ser) {
        String modelId = UUID.randomUUID().toString();
        S3Uploader uploader = new S3Uploader();
        String tmpDir = System.getProperty("java.io.tmpdir");
        try {
            File tmpFile = new File(new File(tmpDir), modelId);
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(tmpFile));
            os.writeObject(ser);
            os.flush();
            os.close();
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(tmpFile));
            uploader.upload(ois, modelId, this.bucketName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean exists() {
        throw new UnsupportedOperationException();
    }

    public <E> E load(Class<E> type) {
        throw new UnsupportedOperationException();
    }
}

