/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.aws.s3.uploader;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.aws.s3.BaseS3;

public class S3Uploader
extends BaseS3 {
    public void multiPartUpload(File file, String bucketName) {
        AmazonS3Client client = new AmazonS3Client(this.creds);
        bucketName = this.ensureValidBucketName(bucketName);
        List buckets = client.listBuckets();
        for (Bucket b : buckets) {
            if (!b.getName().equals(bucketName)) continue;
            this.doMultiPart((AmazonS3)client, bucketName, file);
            return;
        }
        client.createBucket(bucketName);
        this.doMultiPart((AmazonS3)client, bucketName, file);
    }

    public void upload(File file, String bucketName) {
        AmazonS3Client client = new AmazonS3Client(this.creds);
        bucketName = this.ensureValidBucketName(bucketName);
        List buckets = client.listBuckets();
        for (Bucket b : buckets) {
            if (!b.getName().equals(bucketName)) continue;
            client.putObject(bucketName, file.getName(), file);
            return;
        }
        client.createBucket(bucketName);
        client.putObject(bucketName, file.getName(), file);
    }

    private void doMultiPart(AmazonS3 s3Client, String bucketName, File file) {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(bucketName, file.getName());
        InitiateMultipartUploadResult initResponse = s3Client.initiateMultipartUpload(initRequest);
        long contentLength = file.length();
        long partSize = 0x500000L;
        try {
            long filePosition = 0L;
            int i = 1;
            while (filePosition < contentLength) {
                partSize = Math.min(partSize, contentLength - filePosition);
                UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(bucketName).withKey(file.getName()).withUploadId(initResponse.getUploadId()).withPartNumber(i).withFileOffset(filePosition).withFile(file).withPartSize(partSize);
                partETags.add(s3Client.uploadPart(uploadRequest).getPartETag());
                filePosition += partSize;
                ++i;
            }
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(bucketName, file.getName(), initResponse.getUploadId(), partETags);
            s3Client.completeMultipartUpload(compRequest);
        }
        catch (Exception e) {
            s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, file.getName(), initResponse.getUploadId()));
        }
    }

    private String ensureValidBucketName(String bucketName) {
        String formatted = bucketName.replaceAll("\\s+", "_");
        int length = bucketName.length();
        if (length >= 62) {
            length = 62;
        }
        formatted = formatted.substring(0, length);
        formatted = formatted.replace(".", "d");
        if ((formatted = formatted.toLowerCase()).endsWith("-")) {
            formatted = formatted.substring(0, length - 1);
        }
        return formatted;
    }

    public void upload(InputStream is, String name, String bucketName) {
        AmazonS3 client = this.getClient();
        bucketName = this.ensureValidBucketName(bucketName);
        List buckets = client.listBuckets();
        ObjectMetadata med = new ObjectMetadata();
        for (Bucket b : buckets) {
            if (!b.getName().equals(bucketName)) continue;
            client.putObject(bucketName, name, is, med);
            return;
        }
        client.createBucket(bucketName);
        client.putObject(bucketName, name, is, med);
    }
}

