/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.dbn;

import java.util.List;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.nn.BaseMultiLayerNetwork;
import org.deeplearning4j.nn.NeuralNetwork;
import org.deeplearning4j.rbm.RBM;
import org.jblas.DoubleMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBN
extends BaseMultiLayerNetwork {
    private static final long serialVersionUID = -9068772752220902983L;
    private static Logger log = LoggerFactory.getLogger(DBN.class);

    public DBN() {
    }

    public DBN(int nIns, int[] hiddenLayerSizes, int nOuts, int nLayers, RandomGenerator rng, DoubleMatrix input, DoubleMatrix labels) {
        super(nIns, hiddenLayerSizes, nOuts, nLayers, rng, input, labels);
    }

    public DBN(int nIns, int[] hiddenLayerSizes, int nOuts, int nLayers, RandomGenerator rng) {
        super(nIns, hiddenLayerSizes, nOuts, nLayers, rng);
    }

    @Override
    public void trainNetwork(DoubleMatrix input, DoubleMatrix labels, Object[] otherParams) {
        int k = (Integer)otherParams[0];
        double lr = (Double)otherParams[1];
        int epochs = (Integer)otherParams[2];
        this.pretrain(input, k, lr, epochs);
        if (otherParams.length < 3) {
            this.finetune(labels, lr, epochs);
        } else {
            double finetuneLr = otherParams.length > 3 ? (Double)otherParams[3] : lr;
            int finetuneEpochs = otherParams.length > 4 ? (Integer)otherParams[4] : epochs;
            this.finetune(labels, finetuneLr, finetuneEpochs);
        }
    }

    @Override
    public void pretrain(DoubleMatrix input, Object[] otherParams) {
        int k = (Integer)otherParams[0];
        double lr = (Double)otherParams[1];
        int epochs = (Integer)otherParams[2];
        this.pretrain(input, k, lr, epochs);
    }

    public void pretrain(DoubleMatrix input, int k, double learningRate, int epochs) {
        if (this.getInput() == null || this.getLayers() == null || this.getLayers()[0] == null || this.getSigmoidLayers() == null || this.getSigmoidLayers()[0] == null) {
            this.setInput(input);
            this.initializeLayers(input);
        } else {
            this.setInput(input);
        }
        DoubleMatrix layerInput = null;
        for (int i = 0; i < this.getnLayers(); ++i) {
            layerInput = i == 0 ? this.getInput() : (this.isUseHiddenActivationsForwardProp() ? this.getSigmoidLayers()[i - 1].sampleHGivenV(layerInput) : this.getLayers()[i - 1].sampleHiddenGivenVisible(layerInput).getSecond());
            log.info("Training on layer " + (i + 1));
            if (this.isForceNumEpochs()) {
                for (int epoch = 0; epoch < epochs; ++epoch) {
                    log.info("Error on epoch " + epoch + " for layer " + (i + 1) + " is " + this.getLayers()[i].getReConstructionCrossEntropy());
                    this.getLayers()[i].train(layerInput, learningRate, new Object[]{k, learningRate});
                    this.getLayers()[i].epochDone(epoch);
                }
                continue;
            }
            this.getLayers()[i].trainTillConvergence(layerInput, learningRate, new Object[]{k, learningRate, epochs});
        }
    }

    public void pretrain(int k, double learningRate, int epochs) {
        this.pretrain(this.getInput(), k, learningRate, epochs);
    }

    @Override
    public NeuralNetwork createLayer(DoubleMatrix input, int nVisible, int nHidden, DoubleMatrix W, DoubleMatrix hBias, DoubleMatrix vBias, RandomGenerator rng, int index) {
        RBM ret = (RBM)new RBM.Builder().useRegularization(this.isUseRegularization()).useAdaGrad(this.isUseAdaGrad()).normalizeByInputRows(this.isNormalizeByInputRows()).withMomentum(this.getMomentum()).withSparsity(this.getSparsity()).withDistribution(this.getDist()).numberOfVisible(nVisible).numHidden(nHidden).withWeights(W).withDropOut(this.dropOut).withInput(input).withVisibleBias(vBias).withHBias(hBias).withDistribution(this.getDist()).withRandom(rng).renderWeights(this.getRenderWeightsEveryNEpochs()).fanIn(this.getFanIn()).build();
        ret.setGradientListeners((List)this.gradientListeners.get(index));
        return ret;
    }

    @Override
    public NeuralNetwork[] createNetworkLayers(int numLayers) {
        return new RBM[numLayers];
    }

    public static class Builder
    extends BaseMultiLayerNetwork.Builder<DBN> {
        public Builder() {
            this.clazz = DBN.class;
        }
    }
}

