/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.distributions;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.random.RandomGenerator;

public class Distributions {
    public static RealDistribution normal(RandomGenerator rng, double std) {
        return new NormalDistribution(rng, 0.0, std, 1.0E-9);
    }

    public static RealDistribution uniform(RandomGenerator rng, double fanIn) {
        fanIn = Math.abs(fanIn);
        return new UniformRealDistribution(rng, -fanIn, fanIn);
    }

    public static RealDistribution uniform(RandomGenerator rng, int nIn, int nOut) {
        double fanIn = -4.0 * Math.sqrt(6.0 / (double)(nOut + nIn));
        return Distributions.uniform(rng, fanIn);
    }

    public static RealDistribution uniform(RandomGenerator rng) {
        double fanIn = 0.1;
        return new UniformRealDistribution(rng, -fanIn, fanIn);
    }
}

