/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn;

import java.io.Serializable;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.nn.activation.ActivationFunction;
import org.deeplearning4j.nn.activation.Sigmoid;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;

public class HiddenLayer
implements Serializable {
    protected static final long serialVersionUID = 915783367350830495L;
    protected int nIn;
    protected int nOut;
    protected DoubleMatrix W;
    protected DoubleMatrix b;
    protected RandomGenerator rng;
    protected DoubleMatrix input;
    protected ActivationFunction activationFunction = new Sigmoid();
    protected RealDistribution dist;

    protected HiddenLayer() {
    }

    public HiddenLayer(int nIn, int nOut, DoubleMatrix W, DoubleMatrix b, RandomGenerator rng, DoubleMatrix input, ActivationFunction activationFunction) {
        this(nIn, nOut, W, b, rng, input, activationFunction, null);
    }

    public HiddenLayer(int nIn, int nOut, DoubleMatrix W, DoubleMatrix b, RandomGenerator rng, DoubleMatrix input) {
        this(nIn, nOut, W, b, rng, input, null, null);
    }

    public HiddenLayer(int nIn, int nOut, DoubleMatrix W, DoubleMatrix b, RandomGenerator rng, DoubleMatrix input, ActivationFunction activationFunction, RealDistribution dist) {
        this.nIn = nIn;
        this.nOut = nOut;
        this.input = input;
        if (activationFunction != null) {
            this.activationFunction = activationFunction;
        }
        this.rng = rng == null ? new MersenneTwister(1234) : rng;
        this.dist = dist == null ? new NormalDistribution(this.rng, 0.0, 0.01, 1.0E-9) : dist;
        if (W == null) {
            this.W = DoubleMatrix.zeros((int)nIn, (int)nOut);
            for (int i = 0; i < this.W.rows; ++i) {
                this.W.putRow(i, new DoubleMatrix(this.dist.sample(this.W.columns)));
            }
        } else {
            this.W = W;
        }
        this.b = b == null ? DoubleMatrix.zeros((int)nOut) : b;
    }

    public HiddenLayer(int nIn, int nOut, DoubleMatrix W, DoubleMatrix b, RandomGenerator rng, DoubleMatrix input, RealDistribution dist) {
        this.nIn = nIn;
        this.nOut = nOut;
        this.input = input;
        this.rng = rng == null ? new MersenneTwister(1234) : rng;
        this.dist = dist == null ? new NormalDistribution(this.rng, 0.0, 0.01, 1.0E-9) : dist;
        if (W == null) {
            this.W = DoubleMatrix.zeros((int)nIn, (int)nOut);
            for (int i = 0; i < this.W.rows; ++i) {
                this.W.putRow(i, new DoubleMatrix(this.dist.sample(this.W.columns)));
            }
        } else {
            this.W = W;
        }
        this.b = b == null ? DoubleMatrix.zeros((int)nOut) : b;
    }

    public synchronized int getnIn() {
        return this.nIn;
    }

    public synchronized void setnIn(int nIn) {
        this.nIn = nIn;
    }

    public synchronized int getnOut() {
        return this.nOut;
    }

    public synchronized void setnOut(int nOut) {
        this.nOut = nOut;
    }

    public synchronized DoubleMatrix getW() {
        return this.W;
    }

    public synchronized void setW(DoubleMatrix w) {
        this.W = w;
    }

    public synchronized DoubleMatrix getB() {
        return this.b;
    }

    public synchronized void setB(DoubleMatrix b) {
        this.b = b;
    }

    public synchronized RandomGenerator getRng() {
        return this.rng;
    }

    public synchronized void setRng(RandomGenerator rng) {
        this.rng = rng;
    }

    public synchronized DoubleMatrix getInput() {
        return this.input;
    }

    public synchronized void setInput(DoubleMatrix input) {
        this.input = input;
    }

    public synchronized ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public synchronized void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    public HiddenLayer clone() {
        HiddenLayer layer = new HiddenLayer();
        layer.b = this.b.dup();
        layer.W = this.W.dup();
        if (this.input != null) {
            layer.input = this.input.dup();
        }
        if (this.dist != null) {
            layer.dist = this.dist;
        }
        layer.activationFunction = this.activationFunction;
        layer.nOut = this.nOut;
        layer.nIn = this.nIn;
        layer.rng = this.rng;
        return layer;
    }

    public HiddenLayer transpose() {
        HiddenLayer layer = new HiddenLayer();
        layer.b = this.b.dup();
        layer.W = this.W.transpose();
        if (this.input != null) {
            layer.input = this.input.transpose();
        }
        if (this.dist != null) {
            layer.dist = this.dist;
        }
        layer.activationFunction = this.activationFunction;
        layer.nOut = this.nIn;
        layer.nIn = this.nOut;
        layer.rng = this.rng;
        return layer;
    }

    public synchronized DoubleMatrix activate() {
        DoubleMatrix activation = (DoubleMatrix)this.getActivationFunction().apply(this.getInput().mmul(this.getW()).addRowVector(this.getB()));
        return activation;
    }

    public synchronized DoubleMatrix activate(DoubleMatrix input) {
        if (input != null) {
            this.input = input;
        }
        return this.activate();
    }

    public DoubleMatrix sampleHGivenV(DoubleMatrix input) {
        this.input = input;
        DoubleMatrix ret = MatrixUtil.binomial(this.activate(), 1, this.rng);
        return ret;
    }

    public DoubleMatrix sampleHiddenGivenVisible() {
        DoubleMatrix output = this.activate();
        DoubleMatrix ret = MatrixUtil.binomial(output, 1, this.rng);
        return ret;
    }

    public static class Builder {
        protected int nIn;
        protected int nOut;
        protected DoubleMatrix W;
        protected DoubleMatrix b;
        protected RandomGenerator rng;
        protected DoubleMatrix input;
        protected ActivationFunction activationFunction = new Sigmoid();
        protected RealDistribution dist;

        public Builder dist(RealDistribution dist) {
            this.dist = dist;
            return this;
        }

        public Builder nIn(int nIn) {
            this.nIn = nIn;
            return this;
        }

        public Builder nOut(int nOut) {
            this.nOut = nOut;
            return this;
        }

        public Builder withWeights(DoubleMatrix W) {
            this.W = W;
            return this;
        }

        public Builder withRng(RandomGenerator gen) {
            this.rng = gen;
            return this;
        }

        public Builder withActivation(ActivationFunction function) {
            this.activationFunction = function;
            return this;
        }

        public Builder withBias(DoubleMatrix b) {
            this.b = b;
            return this;
        }

        public Builder withInput(DoubleMatrix input) {
            this.input = input;
            return this;
        }

        public HiddenLayer build() {
            HiddenLayer ret = new HiddenLayer(this.nIn, this.nOut, this.W, this.b, this.rng, this.input);
            ret.activationFunction = this.activationFunction;
            ret.dist = this.dist;
            return ret;
        }
    }
}

