/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn;

import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.nn.HiddenLayer;
import org.deeplearning4j.nn.activation.ActivationFunction;
import org.deeplearning4j.nn.activation.Sigmoid;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;

public class RectifiedLinearHiddenLayer
extends HiddenLayer {
    private static final long serialVersionUID = 2266162281744170946L;

    public RectifiedLinearHiddenLayer() {
    }

    public RectifiedLinearHiddenLayer(int nIn, int nOut, DoubleMatrix W, DoubleMatrix b, RandomGenerator rng, DoubleMatrix input, ActivationFunction activationFunction) {
        this(nIn, nOut, W, b, rng, input, activationFunction, null);
    }

    public RectifiedLinearHiddenLayer(int nIn, int nOut, DoubleMatrix W, DoubleMatrix b, RandomGenerator rng, DoubleMatrix input) {
        this(nIn, nOut, W, b, rng, input, null, null);
    }

    public RectifiedLinearHiddenLayer(int nIn, int nOut, DoubleMatrix W, DoubleMatrix b, RandomGenerator rng, DoubleMatrix input, ActivationFunction activationFunction, RealDistribution dist) {
        super(nIn, nOut, W, b, rng, input, activationFunction, dist);
    }

    public RectifiedLinearHiddenLayer(int nIn, int nOut, DoubleMatrix W, DoubleMatrix b, RandomGenerator rng, DoubleMatrix input, RealDistribution dist) {
        super(nIn, nOut, W, b, rng, input, dist);
    }

    @Override
    public DoubleMatrix sampleHGivenV(DoubleMatrix input) {
        this.input = input;
        DoubleMatrix output = this.activate();
        DoubleMatrix sigH1Mean = MatrixUtil.sigmoid(output);
        DoubleMatrix h1Sample = output.addi(MatrixUtil.normal(this.getRng(), output, 1.0).mul(MatrixFunctions.sqrt((DoubleMatrix)sigH1Mean)));
        MatrixUtil.max(0.0, h1Sample);
        return h1Sample;
    }

    @Override
    public DoubleMatrix sampleHiddenGivenVisible() {
        return this.sampleHGivenV(this.input);
    }

    public static class Builder {
        protected int nIn;
        protected int nOut;
        protected DoubleMatrix W;
        protected DoubleMatrix b;
        protected RandomGenerator rng;
        protected DoubleMatrix input;
        protected ActivationFunction activationFunction = new Sigmoid();
        protected RealDistribution dist;

        public Builder dist(RealDistribution dist) {
            this.dist = dist;
            return this;
        }

        public Builder nIn(int nIn) {
            this.nIn = nIn;
            return this;
        }

        public Builder nOut(int nOut) {
            this.nOut = nOut;
            return this;
        }

        public Builder withWeights(DoubleMatrix W) {
            this.W = W;
            return this;
        }

        public Builder withRng(RandomGenerator gen) {
            this.rng = gen;
            return this;
        }

        public Builder withActivation(ActivationFunction function) {
            this.activationFunction = function;
            return this;
        }

        public Builder withBias(DoubleMatrix b) {
            this.b = b;
            return this;
        }

        public Builder withInput(DoubleMatrix input) {
            this.input = input;
            return this;
        }

        public RectifiedLinearHiddenLayer build() {
            RectifiedLinearHiddenLayer ret = new RectifiedLinearHiddenLayer(this.nIn, this.nOut, this.W, this.b, this.rng, this.input);
            ret.activationFunction = this.activationFunction;
            ret.dist = this.dist;
            return ret;
        }
    }
}

