/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.canova;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.canova.api.io.WritableConverter;
import org.canova.api.records.reader.RecordReader;
import org.canova.api.writable.Writable;
import org.deeplearning4j.datasets.iterator.DataSetIterator;
import org.deeplearning4j.datasets.iterator.DataSetPreProcessor;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.FeatureUtil;

public class RecordReaderDataSetIterator
implements DataSetIterator {
    private RecordReader recordReader;
    private WritableConverter converter;
    private int batchSize = 10;
    private int labelIndex = -1;
    private int numPossibleLabels = -1;

    public RecordReaderDataSetIterator(RecordReader recordReader, WritableConverter converter, int batchSize, int labelIndex, int numPossibleLabels) {
        this.recordReader = recordReader;
        this.converter = converter;
        this.batchSize = batchSize;
        this.labelIndex = labelIndex;
        this.numPossibleLabels = numPossibleLabels;
    }

    public RecordReaderDataSetIterator(RecordReader recordReader, WritableConverter converter) {
        this(recordReader, converter, 10, -1, -1);
    }

    public RecordReaderDataSetIterator(RecordReader recordReader, WritableConverter converter, int labelIndex, int numPossibleLabels) {
        this(recordReader, converter, 10, labelIndex, numPossibleLabels);
    }

    @Override
    public DataSet next(int num) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        for (int i = 0; i < num; ++i) {
            Collection record = this.recordReader.next();
            ArrayList currList = record instanceof List ? (ArrayList)record : new ArrayList(record);
            INDArray label = null;
            INDArray featureVector = Nd4j.create((int)(this.labelIndex >= 0 ? currList.size() - 1 : currList.size()));
            int count = 0;
            for (int j = 0; j < currList.size(); ++j) {
                Writable current;
                if (this.labelIndex >= 0 && j == this.labelIndex) {
                    if (this.numPossibleLabels < 1) {
                        throw new IllegalStateException("Number of possible labels invalid, must be >= 1");
                    }
                    current = (Writable)currList.get(j);
                    if (this.converter != null) {
                        current = this.converter.convert(current);
                    }
                    label = FeatureUtil.toOutcomeVector((int)j, (int)Integer.valueOf(current.toString()));
                    continue;
                }
                current = (Writable)currList.get(j);
                featureVector.putScalar(count++, Double.valueOf(current.toString()).doubleValue());
            }
            dataSets.add(new DataSet(featureVector, this.labelIndex >= 0 ? label : featureVector));
        }
        ArrayList<INDArray> inputs = new ArrayList<INDArray>();
        ArrayList<INDArray> labels = new ArrayList<INDArray>();
        for (DataSet data : dataSets) {
            inputs.add(data.getFeatureMatrix());
            labels.add(data.getLabels());
        }
        return new DataSet(Nd4j.hstack((INDArray[])inputs.toArray(new INDArray[0])), Nd4j.hstack((INDArray[])labels.toArray(new INDArray[0])));
    }

    @Override
    public int totalExamples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int inputColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int totalOutcomes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
    }

    @Override
    public int batch() {
        return this.batchSize;
    }

    @Override
    public int cursor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int numExamples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreProcessor(DataSetPreProcessor preProcessor) {
    }

    @Override
    public boolean hasNext() {
        return this.recordReader.hasNext();
    }

    @Override
    public DataSet next() {
        return this.next(this.batchSize);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

