/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import org.deeplearning4j.datasets.iterator.DataSetIterator;
import org.deeplearning4j.datasets.iterator.DataSetPreProcessor;
import org.nd4j.linalg.dataset.DataSet;

public class SamplingDataSetIterator
implements DataSetIterator {
    private static final long serialVersionUID = -2700563801361726914L;
    private DataSet sampleFrom;
    private int batchSize;
    private int totalNumberSamples;
    private int numTimesSampled;
    private DataSetPreProcessor preProcessor;

    public SamplingDataSetIterator(DataSet sampleFrom, int batchSize, int totalNumberSamples) {
        this.sampleFrom = sampleFrom;
        this.batchSize = batchSize;
        this.totalNumberSamples = totalNumberSamples;
    }

    @Override
    public boolean hasNext() {
        return this.numTimesSampled < this.totalNumberSamples;
    }

    @Override
    public DataSet next() {
        DataSet ret = this.sampleFrom.sample(this.batchSize);
        this.numTimesSampled += this.batchSize;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int totalExamples() {
        return this.totalNumberSamples * this.batchSize;
    }

    @Override
    public int inputColumns() {
        return this.sampleFrom.numInputs();
    }

    @Override
    public int totalOutcomes() {
        return this.sampleFrom.numOutcomes();
    }

    @Override
    public void reset() {
        this.numTimesSampled = 0;
    }

    @Override
    public int batch() {
        return this.batchSize;
    }

    @Override
    public int cursor() {
        return this.numTimesSampled;
    }

    @Override
    public int numExamples() {
        return this.sampleFrom.numExamples();
    }

    @Override
    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    @Override
    public DataSet next(int num) {
        DataSet ret = this.sampleFrom.sample(num);
        ++this.numTimesSampled;
        return ret;
    }
}

