/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.featuredetectors.autoencoder.recursive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Tree
implements Serializable {
    private INDArray vector;
    private INDArray prediction;
    private List<Tree> children;
    private double error;
    private Tree parent;
    private String headWord;
    private String value;
    private String label;
    private String type;
    private int goldLabel;
    private List<String> tokens;
    private List<String> tags;
    private String parse;
    private int begin;
    private int end;

    public Tree(Tree tree) {
        this.setError(tree.error);
        this.setValue(tree.value);
        this.setVector(tree.vector);
        this.setParse(tree.parse);
        this.setLabel(tree.label);
        this.setGoldLabel(tree.goldLabel);
        this.setPrediction(tree.prediction);
        this.setTags(tree.tags);
        this.setBegin(tree.begin);
        this.setEnd(tree.end);
        this.setType(tree.type);
    }

    public Tree(Tree parent, List<String> tokens) {
        this.parent = parent;
        this.tokens = tokens;
        this.children = new ArrayList<Tree>();
    }

    public Tree(List<String> tokens) {
        this.children = new ArrayList<Tree>();
        this.tokens = tokens;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> yield() {
        return this.yield(new ArrayList<String>());
    }

    private List<String> yield(List<String> labels) {
        labels.add(this.label);
        for (Tree t : this.children()) {
            labels.addAll(t.yield());
        }
        return labels;
    }

    public void setGoldLabel(int goldLabel) {
        this.goldLabel = goldLabel;
    }

    public int goldLabel() {
        return this.goldLabel;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String label() {
        return this.label;
    }

    public String value() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public List<Tree> children() {
        if (this.children == null) {
            this.children = new ArrayList<Tree>();
        }
        return this.children;
    }

    public boolean isPreTerminal() {
        if (this.children == null && this.label != null && !this.label.equals("TOP")) {
            this.children = new ArrayList<Tree>();
        }
        if (this.children.size() == 1) {
            Tree child = this.children.get(0);
            return child != null && child.isLeaf();
        }
        return false;
    }

    public Tree firstChild() {
        return this.children.isEmpty() ? null : this.children.get(0);
    }

    public Tree lastChild() {
        return this.children.isEmpty() ? null : this.children.get(this.children.size() - 1);
    }

    public int depth() {
        if (this.isLeaf()) {
            return 0;
        }
        int maxDepth = 0;
        List<Tree> kids = this.children();
        for (Tree kid : kids) {
            int curDepth = kid.depth();
            if (curDepth <= maxDepth) continue;
            maxDepth = curDepth;
        }
        return maxDepth + 1;
    }

    public int depth(Tree node) {
        Tree p = node.parent(this);
        if (this == node) {
            return 0;
        }
        if (p == null) {
            return -1;
        }
        int depth = 1;
        while (this != p) {
            p = p.parent(this);
            ++depth;
        }
        return depth;
    }

    public Tree parent(Tree root) {
        List<Tree> kids = root.children();
        return Tree.traverse(root, kids, this);
    }

    private static Tree traverse(Tree parent, List<Tree> kids, Tree node) {
        for (Tree kid : kids) {
            if (kid == node) {
                return parent;
            }
            Tree ret = node.parent(kid);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public Tree ancestor(int height, Tree root) {
        if (height < 0) {
            throw new IllegalArgumentException("ancestor: height cannot be negative");
        }
        if (height == 0) {
            return this;
        }
        Tree par = this.parent(root);
        if (par == null) {
            return null;
        }
        return par.ancestor(height - 1, root);
    }

    public double errorSum() {
        if (this.isLeaf()) {
            return 0.0;
        }
        if (this.isPreTerminal()) {
            return this.error();
        }
        double error = 0.0;
        for (Tree child : this.children()) {
            error += child.errorSum();
        }
        return this.error() + error;
    }

    public <T extends Tree> List<T> getLeaves() {
        return this.getLeaves(new ArrayList());
    }

    public <T extends Tree> List<T> getLeaves(List<T> list) {
        if (this.isLeaf()) {
            list.add(this);
        } else {
            for (Tree kid : this.children()) {
                kid.getLeaves(list);
            }
        }
        return list;
    }

    public Tree clone() {
        Tree ret = new Tree(this);
        ret.connect(new ArrayList<Tree>(this.children()));
        return ret;
    }

    public double error() {
        return this.error;
    }

    public void setError(double error) {
        this.error = error;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<String> tokens) {
        this.tokens = tokens;
    }

    public void setParent(Tree parent) {
        this.parent = parent;
    }

    public Tree parent() {
        return this.parent;
    }

    public INDArray vector() {
        return this.vector;
    }

    public void setVector(INDArray vector) {
        this.vector = vector;
    }

    public INDArray prediction() {
        return this.prediction;
    }

    public void setPrediction(INDArray prediction) {
        this.prediction = prediction;
    }

    public List<String> tags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<Tree> getChildren() {
        return this.children;
    }

    public String getHeadWord() {
        return this.headWord;
    }

    public void setHeadWord(String headWord) {
        this.headWord = headWord;
    }

    public void setParse(String parse) {
        this.parse = parse;
    }

    public void connect(List<Tree> children) {
        this.children = children;
        for (Tree t : children) {
            t.setParent(this);
        }
    }

    public int getBegin() {
        return this.begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String toString() {
        return "Tree{vector=" + this.vector + ", prediction=" + this.prediction + ", error=" + this.error + ", parent=" + this.parent + ", headWord='" + this.headWord + '\'' + ", value='" + this.value + '\'' + ", label='" + this.label + '\'' + ", type='" + this.type + '\'' + ", goldLabel=" + this.goldLabel + ", tokens=" + this.tokens + ", tags=" + this.tags + ", parse='" + this.parse + '\'' + ", begin=" + this.begin + ", end=" + this.end + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tree)) {
            return false;
        }
        Tree tree = (Tree)o;
        if (this.begin != tree.begin) {
            return false;
        }
        if (this.end != tree.end) {
            return false;
        }
        if (Double.compare(tree.error, this.error) != 0) {
            return false;
        }
        if (this.goldLabel != tree.goldLabel) {
            return false;
        }
        if (this.headWord != null ? !this.headWord.equals(tree.headWord) : tree.headWord != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(tree.label) : tree.label != null) {
            return false;
        }
        if (this.parse != null ? !this.parse.equals(tree.parse) : tree.parse != null) {
            return false;
        }
        if (this.prediction != null ? !this.prediction.equals(tree.prediction) : tree.prediction != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(tree.tags) : tree.tags != null) {
            return false;
        }
        if (this.tokens != null ? !this.tokens.equals(tree.tokens) : tree.tokens != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(tree.type) : tree.type != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(tree.value) : tree.value != null) {
            return false;
        }
        return !(this.vector != null ? !this.vector.equals(tree.vector) : tree.vector != null);
    }

    public int hashCode() {
        int result = this.vector != null ? this.vector.hashCode() : 0;
        result = 31 * result + (this.prediction != null ? this.prediction.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.error);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.headWord != null ? this.headWord.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + this.goldLabel;
        result = 31 * result + (this.tokens != null ? this.tokens.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.parse != null ? this.parse.hashCode() : 0);
        result = 31 * result + this.begin;
        result = 31 * result + this.end;
        return result;
    }
}

