/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.models.featuredetectors.rbm.RBM;
import org.deeplearning4j.nn.api.LayerFactory;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.OutputPreProcessor;
import org.deeplearning4j.nn.conf.deserializers.ActivationFunctionDeSerializer;
import org.deeplearning4j.nn.conf.deserializers.DistributionDeSerializer;
import org.deeplearning4j.nn.conf.deserializers.LayerFactoryDeSerializer;
import org.deeplearning4j.nn.conf.deserializers.RandomGeneratorDeSerializer;
import org.deeplearning4j.nn.conf.deserializers.StepFunctionDeSerializer;
import org.deeplearning4j.nn.conf.serializers.ActivationFunctionSerializer;
import org.deeplearning4j.nn.conf.serializers.DistributionSerializer;
import org.deeplearning4j.nn.conf.serializers.LayerFactorySerializer;
import org.deeplearning4j.nn.conf.serializers.RandomGeneratorSerializer;
import org.deeplearning4j.nn.conf.serializers.StepFunctionSerializer;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.api.StepFunction;
import org.deeplearning4j.optimize.stepfunctions.GradientStepFunction;
import org.nd4j.linalg.api.activation.ActivationFunction;
import org.nd4j.linalg.api.activation.Activations;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class NeuralNetConfiguration
implements Serializable,
Cloneable {
    private double sparsity = 0.0;
    private boolean useAdaGrad = true;
    private double lr = 0.1f;
    protected double corruptionLevel = 0.3f;
    protected int numIterations = 1000;
    protected double momentum = 0.5;
    protected double l2 = 0.0;
    protected boolean useRegularization = false;
    protected Map<Integer, Double> momentumAfter = new HashMap<Integer, Double>();
    protected int resetAdaGradIterations = -1;
    protected double dropOut = 0.0;
    protected boolean applySparsity = false;
    protected WeightInit weightInit = WeightInit.VI;
    protected OptimizationAlgorithm optimizationAlgo = OptimizationAlgorithm.CONJUGATE_GRADIENT;
    protected LossFunctions.LossFunction lossFunction = LossFunctions.LossFunction.RECONSTRUCTION_CROSSENTROPY;
    protected int renderWeightsEveryNumEpochs = -1;
    protected boolean concatBiases = false;
    protected boolean constrainGradientToUnitNorm = false;
    protected long seed = 123L;
    protected transient RandomGenerator rng;
    protected transient RealDistribution dist;
    protected transient Collection<IterationListener> listeners;
    protected transient StepFunction stepFunction = new GradientStepFunction();
    protected transient LayerFactory layerFactory;
    protected List<String> gradientList = new ArrayList<String>();
    protected int nIn;
    protected int nOut;
    protected ActivationFunction activationFunction;
    private RBM.VisibleUnit visibleUnit = RBM.VisibleUnit.BINARY;
    private RBM.HiddenUnit hiddenUnit = RBM.HiddenUnit.BINARY;
    protected int k = 1;
    private int[] weightShape;
    private int[] filterSize = new int[]{2, 2};
    private int numFeatureMaps = 2;
    private int[] featureMapSize = new int[]{2, 2};
    private int[] stride = new int[]{2, 2};
    protected int kernel = 5;
    protected int batchSize = 10;

    public NeuralNetConfiguration() {
    }

    public NeuralNetConfiguration(double sparsity, boolean useAdaGrad, double lr, int k, double corruptionLevel, int numIterations, double momentum, double l2, boolean useRegularization, Map<Integer, Double> momentumAfter, int resetAdaGradIterations, double dropOut, boolean applySparsity, WeightInit weightInit, OptimizationAlgorithm optimizationAlgo, LossFunctions.LossFunction lossFunction, int renderWeightsEveryNumEpochs, boolean concatBiases, boolean constrainGradientToUnitNorm, RandomGenerator rng, RealDistribution dist, long seed, int nIn, int nOut, ActivationFunction activationFunction, RBM.VisibleUnit visibleUnit, RBM.HiddenUnit hiddenUnit, int[] weightShape, int[] filterSize, int[] stride, int[] featureMapSize, int kernel, int batchSize, Collection<IterationListener> listeners, LayerFactory layerFactory) {
        this.batchSize = batchSize;
        this.layerFactory = layerFactory;
        this.listeners = listeners;
        this.sparsity = sparsity;
        this.useAdaGrad = useAdaGrad;
        this.lr = lr;
        this.kernel = kernel;
        this.k = k;
        this.corruptionLevel = corruptionLevel;
        this.numIterations = numIterations;
        this.momentum = momentum;
        this.l2 = l2;
        this.useRegularization = useRegularization;
        this.momentumAfter = momentumAfter;
        this.resetAdaGradIterations = resetAdaGradIterations;
        this.dropOut = dropOut;
        this.applySparsity = applySparsity;
        this.weightInit = weightInit;
        this.optimizationAlgo = optimizationAlgo;
        this.lossFunction = lossFunction;
        this.renderWeightsEveryNumEpochs = renderWeightsEveryNumEpochs;
        this.concatBiases = concatBiases;
        this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
        this.rng = rng;
        this.dist = dist;
        this.seed = seed;
        this.nIn = nIn;
        this.nOut = nOut;
        this.activationFunction = activationFunction;
        this.visibleUnit = visibleUnit;
        this.hiddenUnit = hiddenUnit;
        this.weightShape = weightShape != null ? weightShape : new int[]{nIn, nOut};
        this.filterSize = filterSize;
        this.stride = stride;
        this.featureMapSize = featureMapSize;
    }

    public NeuralNetConfiguration(NeuralNetConfiguration neuralNetConfiguration) {
        this.layerFactory = neuralNetConfiguration.layerFactory;
        this.batchSize = neuralNetConfiguration.batchSize;
        this.sparsity = neuralNetConfiguration.sparsity;
        this.useAdaGrad = neuralNetConfiguration.useAdaGrad;
        this.lr = neuralNetConfiguration.lr;
        this.momentum = neuralNetConfiguration.momentum;
        this.l2 = neuralNetConfiguration.l2;
        this.numIterations = neuralNetConfiguration.numIterations;
        this.k = neuralNetConfiguration.k;
        this.corruptionLevel = neuralNetConfiguration.corruptionLevel;
        this.visibleUnit = neuralNetConfiguration.visibleUnit;
        this.hiddenUnit = neuralNetConfiguration.hiddenUnit;
        this.useRegularization = neuralNetConfiguration.useRegularization;
        this.momentumAfter = neuralNetConfiguration.momentumAfter;
        this.resetAdaGradIterations = neuralNetConfiguration.resetAdaGradIterations;
        this.dropOut = neuralNetConfiguration.dropOut;
        this.applySparsity = neuralNetConfiguration.applySparsity;
        this.weightInit = neuralNetConfiguration.weightInit;
        this.optimizationAlgo = neuralNetConfiguration.optimizationAlgo;
        this.lossFunction = neuralNetConfiguration.lossFunction;
        this.renderWeightsEveryNumEpochs = neuralNetConfiguration.renderWeightsEveryNumEpochs;
        this.concatBiases = neuralNetConfiguration.concatBiases;
        this.constrainGradientToUnitNorm = neuralNetConfiguration.constrainGradientToUnitNorm;
        this.rng = neuralNetConfiguration.rng;
        this.dist = neuralNetConfiguration.dist;
        this.seed = neuralNetConfiguration.seed;
        this.nIn = neuralNetConfiguration.nIn;
        this.nOut = neuralNetConfiguration.nOut;
        this.activationFunction = neuralNetConfiguration.activationFunction;
        this.visibleUnit = neuralNetConfiguration.visibleUnit;
        this.weightShape = neuralNetConfiguration.weightShape;
        this.stride = neuralNetConfiguration.stride;
        this.numFeatureMaps = neuralNetConfiguration.numFeatureMaps;
        this.filterSize = neuralNetConfiguration.filterSize;
        this.featureMapSize = neuralNetConfiguration.featureMapSize;
        if (this.dist == null) {
            this.dist = new NormalDistribution(this.rng, 0.0, 0.01, 1.0E-9);
        }
        this.hiddenUnit = neuralNetConfiguration.hiddenUnit;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getKernel() {
        return this.kernel;
    }

    public void setKernel(int kernel) {
        this.kernel = kernel;
    }

    public LayerFactory getLayerFactory() {
        return this.layerFactory;
    }

    public void setLayerFactory(LayerFactory layerFactory) {
        this.layerFactory = layerFactory;
    }

    public void addVariable(String variable) {
        if (!this.gradientList.contains(variable)) {
            this.gradientList.add(variable);
        }
    }

    public List<String> getGradientList() {
        return this.gradientList;
    }

    public void setGradientList(List<String> gradientList) {
        this.gradientList = gradientList;
    }

    public StepFunction getStepFunction() {
        return this.stepFunction;
    }

    public void setStepFunction(StepFunction stepFunction) {
        this.stepFunction = stepFunction;
    }

    public int[] getFeatureMapSize() {
        return this.featureMapSize;
    }

    public void setFeatureMapSize(int[] featureMapSize) {
        this.featureMapSize = featureMapSize;
    }

    public int[] getWeightShape() {
        return this.weightShape;
    }

    public void setWeightShape(int[] weightShape) {
        this.weightShape = weightShape;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public double getCorruptionLevel() {
        return this.corruptionLevel;
    }

    public RBM.HiddenUnit getHiddenUnit() {
        return this.hiddenUnit;
    }

    public void setHiddenUnit(RBM.HiddenUnit hiddenUnit) {
        this.hiddenUnit = hiddenUnit;
    }

    public RBM.VisibleUnit getVisibleUnit() {
        return this.visibleUnit;
    }

    public void setVisibleUnit(RBM.VisibleUnit visibleUnit) {
        this.visibleUnit = visibleUnit;
    }

    public LossFunctions.LossFunction getLossFunction() {
        return this.lossFunction;
    }

    public void setLossFunction(LossFunctions.LossFunction lossFunction) {
        this.lossFunction = lossFunction;
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    public int getnIn() {
        return this.nIn;
    }

    public void setnIn(int nIn) {
        this.nIn = nIn;
    }

    public int getnOut() {
        return this.nOut;
    }

    public void setnOut(int nOut) {
        this.nOut = nOut;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public boolean isUseAdaGrad() {
        return this.useAdaGrad;
    }

    public void setUseAdaGrad(boolean useAdaGrad) {
        this.useAdaGrad = useAdaGrad;
    }

    public double getLr() {
        return this.lr;
    }

    public void setLr(double lr) {
        this.lr = lr;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public double getL2() {
        return this.l2;
    }

    public void setL2(double l2) {
        this.l2 = l2;
    }

    public boolean isUseRegularization() {
        return this.useRegularization;
    }

    public void setUseRegularization(boolean useRegularization) {
        this.useRegularization = useRegularization;
    }

    public Map<Integer, Double> getMomentumAfter() {
        return this.momentumAfter;
    }

    public void setMomentumAfter(Map<Integer, Double> momentumAfter) {
        this.momentumAfter = momentumAfter;
    }

    public int getResetAdaGradIterations() {
        return this.resetAdaGradIterations;
    }

    public void setResetAdaGradIterations(int resetAdaGradIterations) {
        this.resetAdaGradIterations = resetAdaGradIterations;
    }

    public double getDropOut() {
        return this.dropOut;
    }

    public boolean isApplySparsity() {
        return this.applySparsity;
    }

    public void setApplySparsity(boolean applySparsity) {
        this.applySparsity = applySparsity;
    }

    public WeightInit getWeightInit() {
        return this.weightInit;
    }

    public void setWeightInit(WeightInit weightInit) {
        this.weightInit = weightInit;
    }

    public OptimizationAlgorithm getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public int getRenderWeightIterations() {
        return this.renderWeightsEveryNumEpochs;
    }

    public void setRenderWeightIterations(int renderWeightsEveryNumEpochs) {
        this.renderWeightsEveryNumEpochs = renderWeightsEveryNumEpochs;
    }

    public boolean isConcatBiases() {
        return this.concatBiases;
    }

    public void setConcatBiases(boolean concatBiases) {
        this.concatBiases = concatBiases;
    }

    public boolean isConstrainGradientToUnitNorm() {
        return this.constrainGradientToUnitNorm;
    }

    public void setConstrainGradientToUnitNorm(boolean constrainGradientToUnitNorm) {
        this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
    }

    public RandomGenerator getRng() {
        return this.rng;
    }

    public void setRng(RandomGenerator rng) {
        this.rng = rng;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public RealDistribution getDist() {
        return this.dist;
    }

    public void setDist(RealDistribution dist) {
        this.dist = dist;
    }

    public int[] getFilterSize() {
        return this.filterSize;
    }

    public void setFilterSize(int[] filterSize) {
        this.filterSize = filterSize;
    }

    public int getNumFeatureMaps() {
        return this.numFeatureMaps;
    }

    public void setNumFeatureMaps(int numFeatureMaps) {
        this.numFeatureMaps = numFeatureMaps;
    }

    public int[] getStride() {
        return this.stride;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeuralNetConfiguration)) {
            return false;
        }
        NeuralNetConfiguration that = (NeuralNetConfiguration)o;
        if (this.applySparsity != that.applySparsity) {
            return false;
        }
        if (this.batchSize != that.batchSize) {
            return false;
        }
        if (this.concatBiases != that.concatBiases) {
            return false;
        }
        if (this.constrainGradientToUnitNorm != that.constrainGradientToUnitNorm) {
            return false;
        }
        if (Double.compare(that.corruptionLevel, this.corruptionLevel) != 0) {
            return false;
        }
        if (Double.compare(that.dropOut, this.dropOut) != 0) {
            return false;
        }
        if (this.k != that.k) {
            return false;
        }
        if (this.kernel != that.kernel) {
            return false;
        }
        if (Double.compare(that.l2, this.l2) != 0) {
            return false;
        }
        if (Double.compare(that.lr, this.lr) != 0) {
            return false;
        }
        if (Double.compare(that.momentum, this.momentum) != 0) {
            return false;
        }
        if (this.nIn != that.nIn) {
            return false;
        }
        if (this.nOut != that.nOut) {
            return false;
        }
        if (this.numFeatureMaps != that.numFeatureMaps) {
            return false;
        }
        if (this.numIterations != that.numIterations) {
            return false;
        }
        if (this.renderWeightsEveryNumEpochs != that.renderWeightsEveryNumEpochs) {
            return false;
        }
        if (this.resetAdaGradIterations != that.resetAdaGradIterations) {
            return false;
        }
        if (this.seed != that.seed) {
            return false;
        }
        if (Double.compare(that.sparsity, this.sparsity) != 0) {
            return false;
        }
        if (this.useAdaGrad != that.useAdaGrad) {
            return false;
        }
        if (this.useRegularization != that.useRegularization) {
            return false;
        }
        if (this.activationFunction != null ? !this.activationFunction.equals(that.activationFunction) : that.activationFunction != null) {
            return false;
        }
        if (!Arrays.equals(this.featureMapSize, that.featureMapSize)) {
            return false;
        }
        if (!Arrays.equals(this.filterSize, that.filterSize)) {
            return false;
        }
        if (this.gradientList != null ? !this.gradientList.equals(that.gradientList) : that.gradientList != null) {
            return false;
        }
        if (this.hiddenUnit != that.hiddenUnit) {
            return false;
        }
        if (this.layerFactory != null ? !this.layerFactory.equals(that.layerFactory) : that.layerFactory != null) {
            return false;
        }
        if (this.lossFunction != that.lossFunction) {
            return false;
        }
        if (this.momentumAfter != null ? !this.momentumAfter.equals(that.momentumAfter) : that.momentumAfter != null) {
            return false;
        }
        if (this.optimizationAlgo != that.optimizationAlgo) {
            return false;
        }
        if (!Arrays.equals(this.stride, that.stride)) {
            return false;
        }
        if (this.visibleUnit != that.visibleUnit) {
            return false;
        }
        if (this.weightInit != that.weightInit) {
            return false;
        }
        return Arrays.equals(this.weightShape, that.weightShape);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.sparsity);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.useAdaGrad ? 1 : 0);
        temp = Double.doubleToLongBits(this.lr);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.corruptionLevel);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.numIterations;
        temp = Double.doubleToLongBits(this.momentum);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.l2);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.useRegularization ? 1 : 0);
        result = 31 * result + (this.momentumAfter != null ? this.momentumAfter.hashCode() : 0);
        result = 31 * result + this.resetAdaGradIterations;
        temp = Double.doubleToLongBits(this.dropOut);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.applySparsity ? 1 : 0);
        result = 31 * result + (this.weightInit != null ? this.weightInit.hashCode() : 0);
        result = 31 * result + (this.optimizationAlgo != null ? this.optimizationAlgo.hashCode() : 0);
        result = 31 * result + (this.lossFunction != null ? this.lossFunction.hashCode() : 0);
        result = 31 * result + this.renderWeightsEveryNumEpochs;
        result = 31 * result + (this.concatBiases ? 1 : 0);
        result = 31 * result + (this.constrainGradientToUnitNorm ? 1 : 0);
        result = 31 * result + (int)(this.seed ^ this.seed >>> 32);
        result = 31 * result + (this.layerFactory != null ? this.layerFactory.hashCode() : 0);
        result = 31 * result + (this.gradientList != null ? this.gradientList.hashCode() : 0);
        result = 31 * result + this.nIn;
        result = 31 * result + this.nOut;
        result = 31 * result + (this.activationFunction != null ? this.activationFunction.hashCode() : 0);
        result = 31 * result + (this.visibleUnit != null ? this.visibleUnit.hashCode() : 0);
        result = 31 * result + (this.hiddenUnit != null ? this.hiddenUnit.hashCode() : 0);
        result = 31 * result + this.k;
        result = 31 * result + (this.weightShape != null ? Arrays.hashCode(this.weightShape) : 0);
        result = 31 * result + (this.filterSize != null ? Arrays.hashCode(this.filterSize) : 0);
        result = 31 * result + this.numFeatureMaps;
        result = 31 * result + (this.featureMapSize != null ? Arrays.hashCode(this.featureMapSize) : 0);
        result = 31 * result + (this.stride != null ? Arrays.hashCode(this.stride) : 0);
        result = 31 * result + this.kernel;
        result = 31 * result + this.batchSize;
        return result;
    }

    public String toString() {
        return "NeuralNetConfiguration{sparsity=" + this.sparsity + ", useAdaGrad=" + this.useAdaGrad + ", lr=" + this.lr + ", k=" + this.k + ", corruptionLevel=" + this.corruptionLevel + ", numIterations=" + this.numIterations + ", momentum=" + this.momentum + ", l2=" + this.l2 + ", useRegularization=" + this.useRegularization + ", momentumAfter=" + this.momentumAfter + ", resetAdaGradIterations=" + this.resetAdaGradIterations + ", dropOut=" + this.dropOut + ", applySparsity=" + this.applySparsity + ", weightInit=" + (Object)((Object)this.weightInit) + ", optimizationAlgo=" + (Object)((Object)this.optimizationAlgo) + ", lossFunction=" + this.lossFunction + ", renderWeightsEveryNumEpochs=" + this.renderWeightsEveryNumEpochs + ", concatBiases=" + this.concatBiases + ", constrainGradientToUnitNorm=" + this.constrainGradientToUnitNorm + ", rng=" + this.rng + ", dist=" + this.dist + ", seed=" + this.seed + ", nIn=" + this.nIn + ", nOut=" + this.nOut + ", activationFunction=" + this.activationFunction + ", visibleUnit=" + (Object)((Object)this.visibleUnit) + ", hiddenUnit=" + (Object)((Object)this.hiddenUnit) + ", weightShape=" + Arrays.toString(this.weightShape) + ", filterSize=" + Arrays.toString(this.filterSize) + ", numFeatureMaps=" + this.numFeatureMaps + ", featureMapSize=" + Arrays.toString(this.featureMapSize) + ", stride=" + Arrays.toString(this.stride) + '}';
    }

    public static void setClassifier(NeuralNetConfiguration conf) {
        NeuralNetConfiguration.setClassifier(conf, true);
    }

    public static void setClassifier(NeuralNetConfiguration conf, boolean rows) {
        conf.setActivationFunction(rows ? Activations.softMaxRows() : Activations.softmax());
        conf.setLossFunction(LossFunctions.LossFunction.MCXENT);
        conf.setWeightInit(WeightInit.ZERO);
    }

    public NeuralNetConfiguration clone() {
        return new NeuralNetConfiguration(this);
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            String ret = mapper.writeValueAsString((Object)this);
            return ret.replaceAll("\"activationFunction\",", "").replaceAll("\"rng\",", "").replaceAll("\"dist\",", "").replaceAll("\"layerFactory\",", "").replaceAll("\"stepFunction\",", "");
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            ret.rng.setSeed(ret.seed);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSparsity(double sparsity) {
        this.sparsity = sparsity;
    }

    public void setCorruptionLevel(double corruptionLevel) {
        this.corruptionLevel = corruptionLevel;
    }

    public void setMomentum(double momentum) {
        this.momentum = momentum;
    }

    public void setDropOut(double dropOut) {
        this.dropOut = dropOut;
    }

    public Collection<IterationListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IterationListener>();
        }
        return this.listeners;
    }

    public void setListeners(Collection<IterationListener> listeners) {
        this.listeners = listeners;
    }

    public static ObjectMapper mapper() {
        ObjectMapper ret = new ObjectMapper();
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        SimpleModule module = new SimpleModule();
        module.addSerializer(LayerFactory.class, (JsonSerializer)new LayerFactorySerializer());
        module.addSerializer(StepFunction.class, (JsonSerializer)new StepFunctionSerializer());
        module.addDeserializer(ActivationFunction.class, (JsonDeserializer)new ActivationFunctionDeSerializer());
        module.addSerializer(ActivationFunction.class, (JsonSerializer)new ActivationFunctionSerializer());
        module.addDeserializer(RandomGenerator.class, (JsonDeserializer)new RandomGeneratorDeSerializer());
        module.addSerializer(RandomGenerator.class, (JsonSerializer)new RandomGeneratorSerializer());
        module.addSerializer(RealDistribution.class, (JsonSerializer)new DistributionSerializer());
        module.addDeserializer(StepFunction.class, (JsonDeserializer)new StepFunctionDeSerializer());
        module.addDeserializer(RealDistribution.class, (JsonDeserializer)new DistributionDeSerializer());
        module.addDeserializer(LayerFactory.class, (JsonDeserializer)new LayerFactoryDeSerializer());
        ret.registerModule((Module)module);
        return ret;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.rng = new MersenneTwister(this.seed);
        this.dist = new UniformRealDistribution();
    }

    public static class Builder {
        private int k = 1;
        private int kernel = 5;
        private double corruptionLevel = 0.3f;
        private double sparsity = 0.0;
        private boolean useAdaGrad = true;
        private double lr = 0.1f;
        private double momentum = 0.5;
        private double l2 = 0.0;
        private boolean useRegularization = false;
        private Map<Integer, Double> momentumAfter;
        private int resetAdaGradIterations = -1;
        private double dropOut = 0.0;
        private boolean applySparsity = false;
        private WeightInit weightInit = WeightInit.VI;
        private OptimizationAlgorithm optimizationAlgo = OptimizationAlgorithm.CONJUGATE_GRADIENT;
        private int renderWeightsEveryNumEpochs = -1;
        private boolean concatBiases = false;
        private boolean constrainGradientToUnitNorm = false;
        private RandomGenerator rng = new MersenneTwister(123);
        private long seed = 123L;
        private RealDistribution dist = new NormalDistribution(this.rng, 0.0, 0.01, 1.0E-9);
        private boolean adagrad = true;
        private LossFunctions.LossFunction lossFunction = LossFunctions.LossFunction.RECONSTRUCTION_CROSSENTROPY;
        private int nIn;
        private int nOut;
        private ActivationFunction activationFunction = Activations.sigmoid();
        private RBM.VisibleUnit visibleUnit = RBM.VisibleUnit.BINARY;
        private RBM.HiddenUnit hiddenUnit = RBM.HiddenUnit.BINARY;
        private int numIterations = 1000;
        private int[] weightShape;
        private int[] filterSize = new int[]{2, 2, 2, 2};
        private int[] featureMapSize = new int[]{2, 2};
        private int numInFeatureMaps = 2;
        private int[] stride = new int[]{2, 2};
        private Collection<IterationListener> listeners;
        private StepFunction stepFunction = new GradientStepFunction();
        private LayerFactory layerFactory;
        private int batchSize = 0;

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder kernel(int kernel) {
            this.kernel = kernel;
            return this;
        }

        public Builder layerFactory(LayerFactory layerFactory) {
            this.layerFactory = layerFactory;
            return this;
        }

        public Builder stepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
            return this;
        }

        public ListBuilder list(int size) {
            if (size < 2) {
                throw new IllegalArgumentException("Number of layers must be > 1");
            }
            ArrayList<Builder> list = new ArrayList<Builder>();
            for (int i = 0; i < size; ++i) {
                list.add(this.clone());
            }
            return new ListBuilder(list);
        }

        public Builder clone() {
            return new Builder().activationFunction(this.activationFunction).layerFactory(this.layerFactory).adagradResetIterations(this.resetAdaGradIterations).applySparsity(this.applySparsity).concatBiases(this.concatBiases).constrainGradientToUnitNorm(this.constrainGradientToUnitNorm).dist(this.dist).dropOut(this.dropOut).featureMapSize(this.featureMapSize).filterSize(this.filterSize).hiddenUnit(this.hiddenUnit).iterations(this.numIterations).l2(this.l2).learningRate(this.lr).useAdaGrad(this.adagrad).stepFunction(this.stepFunction).lossFunction(this.lossFunction).momentumAfter(this.momentumAfter).momentum(this.momentum).listeners(this.listeners).nIn(this.nIn).nOut(this.nOut).optimizationAlgo(this.optimizationAlgo).batchSize(this.batchSize).regularization(this.useRegularization).render(this.renderWeightsEveryNumEpochs).resetAdaGradIterations(this.resetAdaGradIterations).rng(this.rng).seed(this.seed).sparsity(this.sparsity).stride(this.stride).useAdaGrad(this.useAdaGrad).visibleUnit(this.visibleUnit).weightInit(this.weightInit).weightShape(this.weightShape);
        }

        public Builder iterationListener(IterationListener listener) {
            if (this.listeners != null) {
                this.listeners.add(listener);
            } else {
                this.listeners = new ArrayList<IterationListener>();
                this.listeners.add(listener);
            }
            return this;
        }

        public Builder listeners(Collection<IterationListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder featureMapSize(int[] featureMapSize) {
            this.featureMapSize = featureMapSize;
            return this;
        }

        public Builder stride(int[] stride) {
            this.stride = stride;
            return this;
        }

        public Builder filterSize(int ... filterSize) {
            if (filterSize == null) {
                return this;
            }
            if (filterSize.length != 4) {
                throw new IllegalArgumentException("Invalid filter size must be length 2");
            }
            this.filterSize = filterSize;
            return this;
        }

        public Builder weightShape(int[] weightShape) {
            this.weightShape = weightShape;
            return this;
        }

        public Builder iterations(int numIterations) {
            this.numIterations = numIterations;
            return this;
        }

        public Builder dist(RealDistribution dist) {
            this.dist = dist;
            return this;
        }

        public Builder sparsity(double sparsity) {
            this.sparsity = sparsity;
            return this;
        }

        public Builder useAdaGrad(boolean useAdaGrad) {
            this.useAdaGrad = useAdaGrad;
            return this;
        }

        public Builder learningRate(double lr) {
            this.lr = lr;
            return this;
        }

        public Builder momentum(double momentum) {
            this.momentum = momentum;
            return this;
        }

        public Builder k(int k) {
            this.k = k;
            return this;
        }

        public Builder corruptionLevel(double corruptionLevel) {
            this.corruptionLevel = corruptionLevel;
            return this;
        }

        public Builder momentumAfter(Map<Integer, Double> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return this;
        }

        public Builder adagradResetIterations(int resetAdaGradIterations) {
            this.resetAdaGradIterations = resetAdaGradIterations;
            return this;
        }

        public Builder dropOut(double dropOut) {
            this.dropOut = dropOut;
            return this;
        }

        public Builder applySparsity(boolean applySparsity) {
            this.applySparsity = applySparsity;
            return this;
        }

        public Builder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return this;
        }

        public Builder render(int renderWeightsEveryNumEpochs) {
            this.renderWeightsEveryNumEpochs = renderWeightsEveryNumEpochs;
            return this;
        }

        public Builder concatBiases(boolean concatBiases) {
            this.concatBiases = concatBiases;
            return this;
        }

        public Builder rng(RandomGenerator rng) {
            this.rng = rng;
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public NeuralNetConfiguration build() {
            NeuralNetConfiguration ret = new NeuralNetConfiguration(this.sparsity, this.useAdaGrad, this.lr, this.k, this.corruptionLevel, this.numIterations, this.momentum, this.l2, this.useRegularization, this.momentumAfter, this.resetAdaGradIterations, this.dropOut, this.applySparsity, this.weightInit, this.optimizationAlgo, this.lossFunction, this.renderWeightsEveryNumEpochs, this.concatBiases, this.constrainGradientToUnitNorm, this.rng, this.dist, this.seed, this.nIn, this.nOut, this.activationFunction, this.visibleUnit, this.hiddenUnit, this.weightShape, this.filterSize, this.stride, this.featureMapSize, this.kernel, this.batchSize, this.listeners, this.layerFactory);
            ret.useAdaGrad = this.adagrad;
            ret.stepFunction = this.stepFunction;
            return ret;
        }

        public Builder l2(double l2) {
            this.l2 = l2;
            return this;
        }

        public Builder regularization(boolean useRegularization) {
            this.useRegularization = useRegularization;
            return this;
        }

        public Builder resetAdaGradIterations(int resetAdaGradIterations) {
            this.resetAdaGradIterations = resetAdaGradIterations;
            return this;
        }

        public Builder optimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        public Builder lossFunction(LossFunctions.LossFunction lossFunction) {
            this.lossFunction = lossFunction;
            return this;
        }

        public Builder constrainGradientToUnitNorm(boolean constrainGradientToUnitNorm) {
            this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
            return this;
        }

        public Builder nIn(int nIn) {
            this.nIn = nIn;
            return this;
        }

        public Builder nOut(int nOut) {
            this.nOut = nOut;
            return this;
        }

        public Builder activationFunction(ActivationFunction activationFunction) {
            this.activationFunction = activationFunction;
            return this;
        }

        public Builder visibleUnit(RBM.VisibleUnit visibleUnit) {
            this.visibleUnit = visibleUnit;
            return this;
        }

        public Builder hiddenUnit(RBM.HiddenUnit hiddenUnit) {
            this.hiddenUnit = hiddenUnit;
            return this;
        }
    }

    public static class ListBuilder {
        private List<Builder> layerwise;
        private int[] hiddenLayerSizes;
        private boolean useDropConnect = false;
        private boolean pretrain = true;
        private Map<Integer, OutputPreProcessor> preProcessors = new HashMap<Integer, OutputPreProcessor>();

        public ListBuilder(List<Builder> list) {
            this.layerwise = list;
        }

        public ListBuilder preProcessor(Integer layer, OutputPreProcessor preProcessor) {
            this.preProcessors.put(layer, preProcessor);
            return this;
        }

        public ListBuilder preProcessors(Map<Integer, OutputPreProcessor> preProcessors) {
            this.preProcessors = preProcessors;
            return this;
        }

        public ListBuilder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public ListBuilder useDropConnect(boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
            return this;
        }

        public ListBuilder override(ConfOverride override) {
            for (int i = 0; i < this.layerwise.size(); ++i) {
                override.override(i, this.layerwise.get(i));
            }
            return this;
        }

        public ListBuilder hiddenLayerSizes(int ... hiddenLayerSizes) {
            this.hiddenLayerSizes = hiddenLayerSizes;
            return this;
        }

        public MultiLayerConfiguration build() {
            if (this.layerwise.size() != this.hiddenLayerSizes.length + 1) {
                throw new IllegalStateException("Number of hidden layers mut be equal to hidden layer sizes + 1");
            }
            ArrayList<NeuralNetConfiguration> list = new ArrayList<NeuralNetConfiguration>();
            for (int i = 0; i < this.layerwise.size(); ++i) {
                list.add(this.layerwise.get(i).build());
            }
            return new MultiLayerConfiguration.Builder().useDropConnect(this.useDropConnect).pretrain(this.pretrain).preProcessors(this.preProcessors).hiddenLayerSizes(this.hiddenLayerSizes).confs(list).build();
        }
    }

    public static interface ConfOverride {
        public void override(int var1, Builder var2);
    }
}

