/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.gradient;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.gradient.Gradient;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class DefaultGradient
implements Gradient {
    private Map<String, INDArray> gradients = new LinkedHashMap<String, INDArray>();

    @Override
    public Map<String, INDArray> gradientLookupTable() {
        return this.gradients;
    }

    @Override
    public INDArray gradient(List<String> order) {
        ArrayList<INDArray> ret = new ArrayList<INDArray>();
        for (String s : order) {
            if (!this.gradientLookupTable().containsKey(s)) {
                throw new IllegalStateException("Illegal key " + s + " no gradient with key found");
            }
            ret.add(this.gradientLookupTable().get(s));
        }
        return Nd4j.toFlattened(ret);
    }

    @Override
    public INDArray gradient() {
        return Nd4j.toFlattened(this.gradients.values());
    }

    @Override
    public void clear() {
        this.gradients.clear();
    }
}

