/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers;

import java.util.Collection;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.api.StepFunction;
import org.deeplearning4j.optimize.api.TerminationCondition;
import org.deeplearning4j.optimize.solvers.BaseOptimizer;
import org.nd4j.linalg.api.ndarray.INDArray;

public class IterationGradientDescent
extends BaseOptimizer {
    public IterationGradientDescent(NeuralNetConfiguration conf, StepFunction stepFunction, Collection<IterationListener> iterationListeners, Model model) {
        super(conf, stepFunction, iterationListeners, model);
    }

    public IterationGradientDescent(NeuralNetConfiguration conf, StepFunction stepFunction, Collection<IterationListener> iterationListeners, Collection<TerminationCondition> terminationConditions, Model model) {
        super(conf, stepFunction, iterationListeners, terminationConditions, model);
    }

    @Override
    public boolean optimize() {
        for (int i = 0; i < this.conf.getNumIterations(); ++i) {
            Pair<Gradient, Double> score = this.model.gradientAndScore();
            INDArray gradient = score.getFirst().gradient(this.conf.getGradientList());
            INDArray params = this.model.params();
            this.updateGradientAccordingToParams(gradient, params, this.model.batchSize());
            this.model.setParams(params.addi(gradient));
            for (IterationListener listener : this.conf.getListeners()) {
                listener.iterationDone(i);
            }
            log.info("Error at iteration " + i + " was " + this.model.score());
        }
        return true;
    }

    @Override
    public void preProcessLine(INDArray line) {
    }

    @Override
    public void postStep() {
    }
}

