/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Index
implements Serializable {
    private static final long serialVersionUID = 1160629777026141078L;
    Map<Integer, Object> objects = new ConcurrentHashMap<Integer, Object>();
    Map<Object, Integer> indexes = new ConcurrentHashMap<Object, Integer>();

    public synchronized boolean add(Object o, int idx) {
        if (o instanceof String && o.toString().isEmpty()) {
            throw new IllegalArgumentException("Unable to add the empty string");
        }
        Integer index = this.indexes.get(o);
        if (index == null) {
            index = idx;
            this.objects.put(idx, o);
            this.indexes.put(o, index);
            return true;
        }
        return false;
    }

    public synchronized boolean add(Object o) {
        if (o instanceof String && o.toString().isEmpty()) {
            throw new IllegalArgumentException("Unable to add the empty string");
        }
        Integer index = this.indexes.get(o);
        if (index == null) {
            index = this.objects.size();
            this.objects.put(index, o);
            this.indexes.put(o, index);
            return true;
        }
        return false;
    }

    public synchronized int indexOf(Object o) {
        Integer index = this.indexes.get(o);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public synchronized Object get(int i) {
        return this.objects.get(i);
    }

    public int size() {
        return this.objects.size();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("[");
        int sz = this.objects.size();
        for (int i = 0; i < sz; ++i) {
            Object e = this.objects.get(i);
            buff.append(e);
            if (i >= sz - 1) continue;
            buff.append(" , ");
        }
        buff.append("]");
        return buff.toString();
    }
}

