/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.OutputPreProcessor;

public class MultiLayerConfiguration
implements Serializable {
    private int[] hiddenLayerSizes;
    private List<NeuralNetConfiguration> confs;
    private boolean useDropConnect = false;
    private boolean useGaussNewtonVectorProductBackProp = false;
    protected boolean pretrain = true;
    private boolean useRBMPropUpAsActivations = true;
    private double dampingFactor = 100.0;
    private Map<Integer, OutputPreProcessor> processors = new HashMap<Integer, OutputPreProcessor>();

    private MultiLayerConfiguration() {
    }

    public NeuralNetConfiguration getConf(int i) {
        return this.confs.get(i);
    }

    public OutputPreProcessor getPreProcessor(int layer) {
        return this.processors.get(layer);
    }

    public double getDampingFactor() {
        return this.dampingFactor;
    }

    public void setDampingFactor(double dampingFactor) {
        this.dampingFactor = dampingFactor;
    }

    public boolean isUseRBMPropUpAsActivations() {
        return this.useRBMPropUpAsActivations;
    }

    public void setUseRBMPropUpAsActivations(boolean useRBMPropUpAsActivations) {
        this.useRBMPropUpAsActivations = useRBMPropUpAsActivations;
    }

    public boolean isUseDropConnect() {
        return this.useDropConnect;
    }

    public void setUseDropConnect(boolean useDropConnect) {
        this.useDropConnect = useDropConnect;
    }

    public boolean isUseGaussNewtonVectorProductBackProp() {
        return this.useGaussNewtonVectorProductBackProp;
    }

    public void setUseGaussNewtonVectorProductBackProp(boolean useGaussNewtonVectorProductBackProp) {
        this.useGaussNewtonVectorProductBackProp = useGaussNewtonVectorProductBackProp;
    }

    public boolean isPretrain() {
        return this.pretrain;
    }

    public void setPretrain(boolean pretrain) {
        this.pretrain = pretrain;
    }

    public int[] getHiddenLayerSizes() {
        return this.hiddenLayerSizes;
    }

    public void setHiddenLayerSizes(int[] hiddenLayerSizes) {
        this.hiddenLayerSizes = hiddenLayerSizes;
    }

    public List<NeuralNetConfiguration> getConfs() {
        return this.confs;
    }

    public void setConfs(List<NeuralNetConfiguration> confs) {
        this.confs = confs;
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            return mapper.writeValueAsString((Object)this).replaceAll("\"activationFunction\",", "").replaceAll("\"rng\",", "").replaceAll("\"dist\",", "").replaceAll("\"stepFunction\",", "").replaceAll("\"layerFactory\",", "");
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static MultiLayerConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            return (MultiLayerConfiguration)mapper.readValue(json, MultiLayerConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiLayerConfiguration)) {
            return false;
        }
        MultiLayerConfiguration that = (MultiLayerConfiguration)o;
        if (Double.compare(that.dampingFactor, this.dampingFactor) != 0) {
            return false;
        }
        if (this.pretrain != that.pretrain) {
            return false;
        }
        if (this.useDropConnect != that.useDropConnect) {
            return false;
        }
        if (this.useGaussNewtonVectorProductBackProp != that.useGaussNewtonVectorProductBackProp) {
            return false;
        }
        if (this.useRBMPropUpAsActivations != that.useRBMPropUpAsActivations) {
            return false;
        }
        if (this.confs != null ? !this.confs.equals(that.confs) : that.confs != null) {
            return false;
        }
        return Arrays.equals(this.hiddenLayerSizes, that.hiddenLayerSizes);
    }

    public int hashCode() {
        int result = this.hiddenLayerSizes != null ? Arrays.hashCode(this.hiddenLayerSizes) : 0;
        result = 31 * result + (this.confs != null ? this.confs.hashCode() : 0);
        result = 31 * result + (this.useDropConnect ? 1 : 0);
        result = 31 * result + (this.useGaussNewtonVectorProductBackProp ? 1 : 0);
        result = 31 * result + (this.pretrain ? 1 : 0);
        result = 31 * result + (this.useRBMPropUpAsActivations ? 1 : 0);
        long temp = Double.doubleToLongBits(this.dampingFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    static /* synthetic */ int[] access$202(MultiLayerConfiguration x0, int[] x1) {
        x0.hiddenLayerSizes = x1;
        return x1;
    }

    public static class Builder {
        private List<NeuralNetConfiguration> confs = new ArrayList<NeuralNetConfiguration>();
        private int[] hiddenLayerSizes;
        private boolean useDropConnect = false;
        protected boolean pretrain = true;
        protected boolean useRBMPropUpAsActivations = false;
        protected double dampingFactor = 100.0;
        protected Map<Integer, OutputPreProcessor> preProcessors = new HashMap<Integer, OutputPreProcessor>();

        public Builder preProcessor(Integer layer, OutputPreProcessor preProcessor) {
            this.preProcessors.put(layer, preProcessor);
            return this;
        }

        public Builder preProcessors(Map<Integer, OutputPreProcessor> preProcessors) {
            this.preProcessors = preProcessors;
            return this;
        }

        public Builder dampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
            return this;
        }

        public Builder useRBMPropUpAsActivations(boolean useRBMPropUpAsActivations) {
            this.useRBMPropUpAsActivations = useRBMPropUpAsActivations;
            return this;
        }

        public Builder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public Builder useDropConnect(boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
            return this;
        }

        public Builder confs(List<NeuralNetConfiguration> confs) {
            this.confs = confs;
            return this;
        }

        public Builder hiddenLayerSizes(int[] hiddenLayerSizes) {
            this.hiddenLayerSizes = hiddenLayerSizes;
            return this;
        }

        public MultiLayerConfiguration build() {
            MultiLayerConfiguration conf = new MultiLayerConfiguration();
            conf.confs = this.confs;
            if (this.hiddenLayerSizes == null) {
                throw new IllegalStateException("Please specify hidden layer sizes");
            }
            MultiLayerConfiguration.access$202(conf, this.hiddenLayerSizes);
            conf.useDropConnect = this.useDropConnect;
            conf.pretrain = this.pretrain;
            conf.useRBMPropUpAsActivations = this.useRBMPropUpAsActivations;
            conf.dampingFactor = this.dampingFactor;
            conf.processors = this.preProcessors;
            return conf;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)o;
            if (Double.compare(builder.dampingFactor, this.dampingFactor) != 0) {
                return false;
            }
            if (this.pretrain != builder.pretrain) {
                return false;
            }
            if (this.useDropConnect != builder.useDropConnect) {
                return false;
            }
            if (this.useRBMPropUpAsActivations != builder.useRBMPropUpAsActivations) {
                return false;
            }
            if (this.confs != null ? !this.confs.equals(builder.confs) : builder.confs != null) {
                return false;
            }
            if (!Arrays.equals(this.hiddenLayerSizes, builder.hiddenLayerSizes)) {
                return false;
            }
            return !(this.preProcessors != null ? !this.preProcessors.equals(builder.preProcessors) : builder.preProcessors != null);
        }

        public int hashCode() {
            int result = this.confs != null ? this.confs.hashCode() : 0;
            result = 31 * result + (this.hiddenLayerSizes != null ? Arrays.hashCode(this.hiddenLayerSizes) : 0);
            result = 31 * result + (this.useDropConnect ? 1 : 0);
            result = 31 * result + (this.pretrain ? 1 : 0);
            result = 31 * result + (this.useRBMPropUpAsActivations ? 1 : 0);
            long temp = Double.doubleToLongBits(this.dampingFactor);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.preProcessors != null ? this.preProcessors.hashCode() : 0);
            return result;
        }
    }
}

