/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.nd4j.linalg.factory.Nd4j;

public class NeuralNetConfiguration
implements Serializable,
Cloneable {
    private double lr = 0.1;
    protected int numIterations = 5;
    protected double momentum = 0.5;
    protected double l2 = 0.0;
    protected boolean useRegularization = false;
    protected Map<Integer, Double> momentumAfter = new HashMap<Integer, Double>();
    protected int maxNumLineSearchIterations = 5;
    protected OptimizationAlgorithm optimizationAlgo = OptimizationAlgorithm.CONJUGATE_GRADIENT;
    protected boolean constrainGradientToUnitNorm = false;
    protected double rho;
    protected long seed;
    protected StepFunction stepFunction;
    protected Layer layer;
    protected List<String> variables = new ArrayList<String>();
    protected boolean useDropConnect = false;
    private int timeSeriesLength = 1;
    protected int batchSize = 10;
    protected boolean minimize = false;
    protected double l1 = 0.0;
    protected double rmsDecay = 0.0;
    protected boolean miniBatch = true;
    private static final ObjectMapper mapperYaml = NeuralNetConfiguration.initMapperYaml();
    private static final ObjectMapper mapper = NeuralNetConfiguration.initMapper();

    public NeuralNetConfiguration clone() {
        try {
            NeuralNetConfiguration clone = (NeuralNetConfiguration)super.clone();
            if (clone.momentumAfter != null) {
                clone.momentumAfter = new HashMap<Integer, Double>(clone.momentumAfter);
            }
            if (clone.layer != null) {
                clone.layer = clone.layer.clone();
            }
            if (clone.stepFunction != null) {
                clone.stepFunction = clone.stepFunction.clone();
            }
            if (clone.variables != null) {
                clone.variables = new ArrayList<String>(clone.variables);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> variables() {
        return new ArrayList<String>(this.variables);
    }

    public void addVariable(String variable) {
        if (!this.variables.contains(variable)) {
            this.variables.add(variable);
        }
    }

    public void clearVariables() {
        this.variables.clear();
    }

    public String toYaml() {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            String ret = mapper.writeValueAsString((Object)this);
            return ret;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromYaml(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            String ret = mapper.writeValueAsString((Object)this);
            return ret;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper mapperYaml() {
        return mapperYaml;
    }

    private static ObjectMapper initMapperYaml() {
        ObjectMapper ret = new ObjectMapper((JsonFactory)new YAMLFactory());
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        return ret;
    }

    public static ObjectMapper mapper() {
        return mapper;
    }

    private static ObjectMapper initMapper() {
        ObjectMapper ret = new ObjectMapper();
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        return ret;
    }

    public double getLr() {
        return this.lr;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public double getL2() {
        return this.l2;
    }

    public boolean isUseRegularization() {
        return this.useRegularization;
    }

    public Map<Integer, Double> getMomentumAfter() {
        return this.momentumAfter;
    }

    public int getMaxNumLineSearchIterations() {
        return this.maxNumLineSearchIterations;
    }

    public OptimizationAlgorithm getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public boolean isConstrainGradientToUnitNorm() {
        return this.constrainGradientToUnitNorm;
    }

    public double getRho() {
        return this.rho;
    }

    public long getSeed() {
        return this.seed;
    }

    public StepFunction getStepFunction() {
        return this.stepFunction;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public boolean isUseDropConnect() {
        return this.useDropConnect;
    }

    public int getTimeSeriesLength() {
        return this.timeSeriesLength;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public double getL1() {
        return this.l1;
    }

    public double getRmsDecay() {
        return this.rmsDecay;
    }

    public boolean isMiniBatch() {
        return this.miniBatch;
    }

    public void setLr(double lr) {
        this.lr = lr;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public void setMomentum(double momentum) {
        this.momentum = momentum;
    }

    public void setL2(double l2) {
        this.l2 = l2;
    }

    public void setUseRegularization(boolean useRegularization) {
        this.useRegularization = useRegularization;
    }

    public void setMomentumAfter(Map<Integer, Double> momentumAfter) {
        this.momentumAfter = momentumAfter;
    }

    public void setMaxNumLineSearchIterations(int maxNumLineSearchIterations) {
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
    }

    public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public void setConstrainGradientToUnitNorm(boolean constrainGradientToUnitNorm) {
        this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setStepFunction(StepFunction stepFunction) {
        this.stepFunction = stepFunction;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public void setVariables(List<String> variables) {
        this.variables = variables;
    }

    public void setUseDropConnect(boolean useDropConnect) {
        this.useDropConnect = useDropConnect;
    }

    public void setTimeSeriesLength(int timeSeriesLength) {
        this.timeSeriesLength = timeSeriesLength;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public void setL1(double l1) {
        this.l1 = l1;
    }

    public void setRmsDecay(double rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    public void setMiniBatch(boolean miniBatch) {
        this.miniBatch = miniBatch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NeuralNetConfiguration)) {
            return false;
        }
        NeuralNetConfiguration other = (NeuralNetConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLr(), other.getLr()) != 0) {
            return false;
        }
        if (this.getNumIterations() != other.getNumIterations()) {
            return false;
        }
        if (Double.compare(this.getMomentum(), other.getMomentum()) != 0) {
            return false;
        }
        if (Double.compare(this.getL2(), other.getL2()) != 0) {
            return false;
        }
        if (this.isUseRegularization() != other.isUseRegularization()) {
            return false;
        }
        Map<Integer, Double> this$momentumAfter = this.getMomentumAfter();
        Map<Integer, Double> other$momentumAfter = other.getMomentumAfter();
        if (this$momentumAfter == null ? other$momentumAfter != null : !((Object)this$momentumAfter).equals(other$momentumAfter)) {
            return false;
        }
        if (this.getMaxNumLineSearchIterations() != other.getMaxNumLineSearchIterations()) {
            return false;
        }
        OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
        OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
        if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
            return false;
        }
        if (this.isConstrainGradientToUnitNorm() != other.isConstrainGradientToUnitNorm()) {
            return false;
        }
        if (Double.compare(this.getRho(), other.getRho()) != 0) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        StepFunction this$stepFunction = this.getStepFunction();
        StepFunction other$stepFunction = other.getStepFunction();
        if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
            return false;
        }
        Layer this$layer = this.getLayer();
        Layer other$layer = other.getLayer();
        if (this$layer == null ? other$layer != null : !((Object)this$layer).equals(other$layer)) {
            return false;
        }
        List<String> this$variables = this.getVariables();
        List<String> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        if (this.isUseDropConnect() != other.isUseDropConnect()) {
            return false;
        }
        if (this.getTimeSeriesLength() != other.getTimeSeriesLength()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.isMinimize() != other.isMinimize()) {
            return false;
        }
        if (Double.compare(this.getL1(), other.getL1()) != 0) {
            return false;
        }
        if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
            return false;
        }
        return this.isMiniBatch() == other.isMiniBatch();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NeuralNetConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lr = Double.doubleToLongBits(this.getLr());
        result = result * 59 + (int)($lr >>> 32 ^ $lr);
        result = result * 59 + this.getNumIterations();
        long $momentum = Double.doubleToLongBits(this.getMomentum());
        result = result * 59 + (int)($momentum >>> 32 ^ $momentum);
        long $l2 = Double.doubleToLongBits(this.getL2());
        result = result * 59 + (int)($l2 >>> 32 ^ $l2);
        result = result * 59 + (this.isUseRegularization() ? 79 : 97);
        Map<Integer, Double> $momentumAfter = this.getMomentumAfter();
        result = result * 59 + ($momentumAfter == null ? 0 : ((Object)$momentumAfter).hashCode());
        result = result * 59 + this.getMaxNumLineSearchIterations();
        OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
        result = result * 59 + ($optimizationAlgo == null ? 0 : ((Object)((Object)$optimizationAlgo)).hashCode());
        result = result * 59 + (this.isConstrainGradientToUnitNorm() ? 79 : 97);
        long $rho = Double.doubleToLongBits(this.getRho());
        result = result * 59 + (int)($rho >>> 32 ^ $rho);
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        StepFunction $stepFunction = this.getStepFunction();
        result = result * 59 + ($stepFunction == null ? 0 : $stepFunction.hashCode());
        Layer $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 0 : ((Object)$layer).hashCode());
        List<String> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 0 : ((Object)$variables).hashCode());
        result = result * 59 + (this.isUseDropConnect() ? 79 : 97);
        result = result * 59 + this.getTimeSeriesLength();
        result = result * 59 + this.getBatchSize();
        result = result * 59 + (this.isMinimize() ? 79 : 97);
        long $l1 = Double.doubleToLongBits(this.getL1());
        result = result * 59 + (int)($l1 >>> 32 ^ $l1);
        long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
        result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
        result = result * 59 + (this.isMiniBatch() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "NeuralNetConfiguration(lr=" + this.getLr() + ", numIterations=" + this.getNumIterations() + ", momentum=" + this.getMomentum() + ", l2=" + this.getL2() + ", useRegularization=" + this.isUseRegularization() + ", momentumAfter=" + this.getMomentumAfter() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", optimizationAlgo=" + (Object)((Object)this.getOptimizationAlgo()) + ", constrainGradientToUnitNorm=" + this.isConstrainGradientToUnitNorm() + ", rho=" + this.getRho() + ", seed=" + this.getSeed() + ", stepFunction=" + this.getStepFunction() + ", layer=" + this.getLayer() + ", variables=" + this.getVariables() + ", useDropConnect=" + this.isUseDropConnect() + ", timeSeriesLength=" + this.getTimeSeriesLength() + ", batchSize=" + this.getBatchSize() + ", minimize=" + this.isMinimize() + ", l1=" + this.getL1() + ", rmsDecay=" + this.getRmsDecay() + ", miniBatch=" + this.isMiniBatch() + ")";
    }

    public static class Builder
    implements Cloneable {
        private double rmsDecay;
        private double lr = 0.1f;
        private double momentum = 0.5;
        private double l2 = 0.0;
        private boolean useRegularization = false;
        private Map<Integer, Double> momentumAfter;
        private OptimizationAlgorithm optimizationAlgo = OptimizationAlgorithm.CONJUGATE_GRADIENT;
        private boolean constrainGradientToUnitNorm = false;
        private long seed = System.currentTimeMillis();
        private int numIterations = 5;
        private int timeSeriesLength = 1;
        private StepFunction stepFunction = null;
        private Layer layer;
        private int batchSize = 100;
        private int maxNumLineSearchIterations = 5;
        private boolean minimize = false;
        private double l1 = 0.0;
        private boolean useDropConnect = false;
        private double rho;
        private boolean miniBatch = true;

        public Builder timeSeriesLength(int timeSeriesLength) {
            this.timeSeriesLength = timeSeriesLength;
            return this;
        }

        public Builder rho(double rho) {
            this.rho = rho;
            return this;
        }

        public Builder miniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
            return this;
        }

        public Builder useDropConnect(boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
            return this;
        }

        public Builder l1(double l1) {
            this.l1 = l1;
            return this;
        }

        public Builder rmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
            return this;
        }

        public Builder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder maxNumLineSearchIterations(int maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder layer(Layer layer) {
            this.layer = layer;
            return this;
        }

        public Builder stepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
            return this;
        }

        public ListBuilder list(int size) {
            HashMap<Integer, Builder> layerMap = new HashMap<Integer, Builder>();
            for (int i = 0; i < size; ++i) {
                layerMap.put(i, this.clone());
            }
            return new ListBuilder(layerMap);
        }

        public Builder clone() {
            try {
                Builder clone = (Builder)super.clone();
                if (clone.momentumAfter != null) {
                    clone.momentumAfter = new HashMap<Integer, Double>(clone.momentumAfter);
                }
                if (clone.layer != null) {
                    clone.layer = clone.layer.clone();
                }
                if (clone.stepFunction != null) {
                    clone.stepFunction = clone.stepFunction.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder iterations(int numIterations) {
            this.numIterations = numIterations;
            return this;
        }

        public Builder learningRate(double lr) {
            this.lr = lr;
            return this;
        }

        public Builder momentum(double momentum) {
            this.momentum = momentum;
            return this;
        }

        public Builder momentumAfter(Map<Integer, Double> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return this;
        }

        public Builder seed(int seed) {
            this.seed = seed;
            Nd4j.getRandom().setSeed(seed);
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            Nd4j.getRandom().setSeed(seed);
            return this;
        }

        public Builder l2(double l2) {
            this.l2 = l2;
            return this;
        }

        public Builder regularization(boolean useRegularization) {
            this.useRegularization = useRegularization;
            return this;
        }

        public Builder optimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        public Builder constrainGradientToUnitNorm(boolean constrainGradientToUnitNorm) {
            this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
            return this;
        }

        public NeuralNetConfiguration build() {
            if (this.layer == null) {
                throw new IllegalStateException("No layer defined.");
            }
            NeuralNetConfiguration conf = new NeuralNetConfiguration();
            conf.minimize = this.minimize;
            conf.maxNumLineSearchIterations = this.maxNumLineSearchIterations;
            conf.l1 = this.l1;
            conf.batchSize = this.batchSize;
            conf.layer = this.layer;
            conf.lr = this.lr;
            conf.numIterations = this.numIterations;
            conf.momentum = this.momentum;
            conf.l2 = this.l2;
            conf.useRegularization = this.useRegularization;
            conf.momentumAfter = this.momentumAfter;
            conf.optimizationAlgo = this.optimizationAlgo;
            conf.constrainGradientToUnitNorm = this.constrainGradientToUnitNorm;
            conf.seed = this.seed;
            conf.timeSeriesLength = this.timeSeriesLength;
            conf.rmsDecay = this.rmsDecay;
            conf.stepFunction = this.stepFunction;
            conf.useDropConnect = this.useDropConnect;
            conf.miniBatch = this.miniBatch;
            conf.rho = this.rho;
            return conf;
        }
    }

    public static class ListBuilder
    extends MultiLayerConfiguration.Builder {
        private Map<Integer, Builder> layerwise;

        public ListBuilder(Map<Integer, Builder> layerMap) {
            this.layerwise = layerMap;
        }

        @Override
        public ListBuilder backprop(boolean backprop) {
            this.backprop = backprop;
            return this;
        }

        @Override
        public ListBuilder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public ListBuilder layer(int ind, Layer layer) {
            if (this.layerwise.get(0) == null && ind != 0) {
                throw new IllegalArgumentException("LayerZeroIndexError: Layer index must start from 0");
            }
            if (this.layerwise.size() < ind + 1) {
                throw new IllegalArgumentException("IndexOutOfBoundsError: Layer index exceeds listed size");
            }
            Builder builderWithLayer = this.layerwise.get(ind).layer(layer);
            this.layerwise.put(ind, builderWithLayer);
            return this;
        }

        @Override
        public MultiLayerConfiguration build() {
            ArrayList<NeuralNetConfiguration> list = new ArrayList<NeuralNetConfiguration>();
            for (int i = 0; i < this.layerwise.size(); ++i) {
                list.add(this.layerwise.get(i).build());
            }
            return new MultiLayerConfiguration.Builder().backprop(this.backprop).inputPreProcessors(this.inputPreProcessors).pretrain(this.pretrain).confs(list).build();
        }
    }
}

