/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.nd4j.linalg.api.ndarray.INDArray;

public class FeedForwardToRnnPreProcessor
implements InputPreProcessor {
    private static final long serialVersionUID = -6900959538072178994L;
    private final int timeSeriesLength;

    @JsonCreator
    public FeedForwardToRnnPreProcessor(@JsonProperty(value="timeSeriesLength") int timeSeriesLength) {
        this.timeSeriesLength = timeSeriesLength;
    }

    @Override
    public INDArray preProcess(INDArray input) {
        if (input.rank() != 2) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 2 (i.e., activations for FF layer)");
        }
        int[] shape = input.shape();
        INDArray reshaped = input.reshape(new int[]{shape[0] / this.timeSeriesLength, this.timeSeriesLength, shape[1]});
        return reshaped.permute(new int[]{0, 2, 1});
    }

    @Override
    public INDArray backprop(INDArray output) {
        if (output.rank() != 3) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 3 (i.e., epsilons from RNN layer)");
        }
        int[] shape = output.shape();
        INDArray permuted = output.permute(new int[]{0, 2, 1});
        return permuted.reshape(shape[0] * this.timeSeriesLength, shape[1]);
    }

    @Override
    public FeedForwardToRnnPreProcessor clone() {
        try {
            FeedForwardToRnnPreProcessor clone = (FeedForwardToRnnPreProcessor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getTimeSeriesLength() {
        return this.timeSeriesLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeedForwardToRnnPreProcessor)) {
            return false;
        }
        FeedForwardToRnnPreProcessor other = (FeedForwardToRnnPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getTimeSeriesLength() == other.getTimeSeriesLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeedForwardToRnnPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTimeSeriesLength();
        return result;
    }

    public String toString() {
        return "FeedForwardToRnnPreProcessor(timeSeriesLength=" + this.getTimeSeriesLength() + ")";
    }
}

