/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.subsampling;

import java.util.Arrays;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.util.Dropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.loop.coordinatefunction.CoordinateFunction;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.util.ArrayUtil;

public class SubsamplingLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.SubsamplingLayer> {
    private INDArray maxIndexes;

    public SubsamplingLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public SubsamplingLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public double calcL2() {
        return 0.0;
    }

    @Override
    public double calcL1() {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.SUBSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        int inputHeight = this.input().size(-2);
        int inputWidth = this.input().size(-1);
        DefaultGradient retGradient = new DefaultGradient();
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case MAX: {
                int n = epsilon.size(0);
                int c = epsilon.size(1);
                int outH = epsilon.size(2);
                int outW = epsilon.size(3);
                INDArray retE = Nd4j.zeros((int[])new int[]{n, c, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize()[0], ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize()[1], outH, outW});
                INDArray reshaped = retE.reshape(new int[]{n, c, -1, outH, outW});
                INDArray reshapeEpsilon = Nd4j.rollAxis((INDArray)reshaped, (int)2);
                final INDArray finalEps = epsilon;
                final INDArray reshapedEps = reshapeEpsilon;
                Shape.iterate((int)0, (int)4, (int[])new int[]{n, c, outH, outW}, (int[])new int[4], (CoordinateFunction)new CoordinateFunction(){

                    public void process(int[] ... coord) {
                        try {
                            int[] i = coord[0];
                            double epsGet = finalEps.getDouble(i);
                            int idx = SubsamplingLayer.this.maxIndexes.getInt(i);
                            INDArray sliceToGetFrom = reshapedEps.get(new INDArrayIndex[]{NDArrayIndex.point((int)idx)});
                            sliceToGetFrom.putScalar(i, epsGet);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Iterated to " + Arrays.toString(coord[0]) + " out of shape for indexes " + Arrays.toString(SubsamplingLayer.this.maxIndexes.shape()) + " and final eps shape " + Arrays.toString(finalEps.shape()));
                        }
                    }
                });
                reshapeEpsilon = Convolution.col2im((INDArray)retE, (int[])((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride(), (int[])((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding(), (int)inputHeight, (int)inputWidth);
                return new Pair<Gradient, INDArray>(retGradient, reshapeEpsilon);
            }
            case AVG: {
                INDArray retE = epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.newAxis(), NDArrayIndex.newAxis()});
                INDArray reshapeEpsilon = Nd4j.tile((INDArray)retE, (int[])new int[]{1, 1, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize()[0], ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize()[1], 1, 1});
                reshapeEpsilon = Convolution.col2im((INDArray)reshapeEpsilon, (int[])((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride(), (int[])((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding(), (int)inputHeight, (int)inputWidth);
                reshapeEpsilon.divi((Number)ArrayUtil.prod((int[])((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize()));
                return new Pair<Gradient, INDArray>(retGradient, reshapeEpsilon);
            }
            case NONE: {
                return new Pair<Gradient, INDArray>(retGradient, epsilon);
            }
        }
        throw new IllegalStateException("Un supported pooling type");
    }

    @Override
    public INDArray activate(boolean training) {
        if (training && this.conf.getLayer().getDropOut() > 0.0) {
            this.dropoutMask = Dropout.applyDropout(this.input, this.conf.getLayer().getDropOut(), this.dropoutMask);
        }
        INDArray pooled = Convolution.im2col((INDArray)this.input, (int[])((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize(), (int[])((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride(), (int[])((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding());
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case AVG: {
                return pooled.mean(new int[]{2, 3});
            }
            case MAX: {
                int n = pooled.size(0);
                int c = pooled.size(1);
                int kh = pooled.size(2);
                int kw = pooled.size(3);
                int outWidth = pooled.size(4);
                int outHeight = pooled.size(5);
                INDArray ret = pooled.reshape(new int[]{n, c, kh * kw, outHeight, outWidth});
                this.maxIndexes = Nd4j.argMax((INDArray)ret, (int[])new int[]{2});
                return ret.max(new int[]{2});
            }
            case NONE: {
                return this.input;
            }
        }
        throw new IllegalStateException("Pooling type not supported!");
    }

    @Override
    public Gradient error(INDArray input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray indArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void merge(Layer layer, int batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray activationMean() {
        return Nd4j.create((int)0);
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void iterate(INDArray input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fit() {
    }

    @Override
    public int numParams() {
        return 0;
    }

    @Override
    public void fit(INDArray input) {
    }

    @Override
    public void computeGradientAndScore() {
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void accumulateScore(double accum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return Nd4j.create((int)0);
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

