/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.Nd4j;

public class DefaultParamInitializer
implements ParamInitializer {
    public static final String WEIGHT_KEY = "W";
    public static final String BIAS_KEY = "b";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        if (!(conf.getLayer() instanceof FeedForwardLayer)) {
            throw new IllegalArgumentException("unsupported layer type: " + conf.getLayer().getClass().getName());
        }
        params.put(WEIGHT_KEY, this.createWeightMatrix(conf));
        params.put(BIAS_KEY, this.createBias(conf));
        conf.addVariable(WEIGHT_KEY);
        conf.addVariable(BIAS_KEY);
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, Configuration extraConf) {
        this.init(params, conf);
    }

    protected INDArray createBias(NeuralNetConfiguration conf) {
        FeedForwardLayer layerConf = (FeedForwardLayer)conf.getLayer();
        INDArray ret = Nd4j.valueArrayOf((int)layerConf.getNOut(), (double)layerConf.getBiasInit());
        ret.data().persist();
        return ret;
    }

    protected INDArray createWeightMatrix(NeuralNetConfiguration conf) {
        FeedForwardLayer layerConf = (FeedForwardLayer)conf.getLayer();
        Distribution dist = Distributions.createDistribution(layerConf.getDist());
        INDArray ret = WeightInitUtil.initWeights(layerConf.getNIn(), layerConf.getNOut(), layerConf.getWeightInit(), dist);
        ret.data().persist();
        return ret;
    }
}

