/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;

@Deprecated
public class ImageLoader {
    private int width = -1;
    private int height = -1;

    public ImageLoader() {
    }

    public ImageLoader(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public INDArray asRowVector(File f) throws Exception {
        return ArrayUtil.toNDArray((int[])this.flattenedImageFromFile(f));
    }

    public INDArray asImageMiniBatches(File f, int numMiniBatches, int numRowsPerSlice) {
        try {
            INDArray d = this.asMatrix(f);
            INDArray f2 = Nd4j.create((int[])new int[]{numMiniBatches, numRowsPerSlice, d.columns()});
            return f2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public INDArray asMatrix(File f) throws IOException {
        return ArrayUtil.toNDArray((int[][])this.fromFile(f));
    }

    public int[] flattenedImageFromFile(File f) throws Exception {
        return ArrayUtil.flatten((int[][])this.fromFile(f));
    }

    public int[][] fromFile(File file) throws IOException {
        BufferedImage image = ImageIO.read(file);
        if (this.height > 0 && this.width > 0) {
            image = ImageLoader.toBufferedImage(image.getScaledInstance(this.height, this.width, 4));
        }
        Raster raster = image.getData();
        int w = raster.getWidth();
        int h = raster.getHeight();
        int[][] ret = new int[w][h];
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                ret[i][j] = raster.getSample(i, j, 0);
            }
        }
        return ret;
    }

    public static BufferedImage toBufferedImageRGB(INDArray arr) {
        if (arr.rank() < 3) {
            throw new IllegalArgumentException("Arr must be 3d");
        }
        int height = arr.size(-2);
        int width = arr.size(-1);
        BufferedImage image = new BufferedImage(width, height, 2);
        int[] data = new int[arr.size(-1) * arr.size(-2)];
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int red = y * 255 / (height - 1);
            for (int x = 0; x < width; ++x) {
                int green = x * 255 / (width - 1);
                int blue = 128;
                data[i++] = red << 16 | green << 8 | blue;
            }
        }
        image.setRGB(0, 0, width, height, data, 0, width);
        return image;
    }

    public static BufferedImage toImage(INDArray matrix) {
        if (matrix.isMatrix()) {
            BufferedImage img = new BufferedImage(matrix.size(-1), matrix.size(-2), 1);
            INDArray toRound = matrix;
            WritableRaster r = img.getRaster();
            int[] equiv = new int[matrix.length()];
            for (int i = 0; i < equiv.length; ++i) {
                equiv[i] = (int)toRound.linearView().getDouble(i) * 256;
            }
            r.setDataElements(0, 0, matrix.columns(), matrix.rows(), equiv);
            return img;
        }
        BufferedImage img = new BufferedImage(matrix.size(-1), matrix.size(-2), 1);
        INDArray toRound = Transforms.sigmoid((INDArray)matrix);
        WritableRaster r = img.getRaster();
        int[] equiv = new int[matrix.length()];
        for (int i = 0; i < equiv.length; ++i) {
            equiv[i] = (int)toRound.linearView().getDouble(i);
        }
        r.setDataElements(0, 0, matrix.size(-1), matrix.size(-2), equiv);
        return img;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

