/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.util.ArchiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MnistFetcher {
    protected static final Logger log = LoggerFactory.getLogger(MnistFetcher.class);
    protected File BASE_DIR = new File(System.getProperty("user.home"));
    protected static final String LOCAL_DIR_NAME = "MNIST";
    protected File FILE_DIR = new File(this.BASE_DIR, "MNIST");
    private File fileDir;
    private static final String trainingFilesURL = "http://yann.lecun.com/exdb/mnist/train-images-idx3-ubyte.gz";
    private static final String trainingFilesFilename = "images-idx1-ubyte.gz";
    public static final String trainingFilesFilename_unzipped = "images-idx1-ubyte";
    private static final String trainingFileLabelsURL = "http://yann.lecun.com/exdb/mnist/train-labels-idx1-ubyte.gz";
    private static final String trainingFileLabelsFilename = "labels-idx1-ubyte.gz";
    public static final String trainingFileLabelsFilename_unzipped = "labels-idx1-ubyte";
    private static final String testFilesURL = "http://yann.lecun.com/exdb/mnist/t10k-images-idx3-ubyte.gz";
    private static final String testFilesFilename = "t10k-images-idx3-ubyte.gz";
    public static final String testFilesFilename_unzipped = "t10k-images-idx3-ubyte";
    private static final String testFileLabelsURL = "http://yann.lecun.com/exdb/mnist/t10k-labels-idx1-ubyte.gz";
    private static final String testFileLabelsFilename = "t10k-labels-idx1-ubyte.gz";
    public static final String testFileLabelsFilename_unzipped = "t10k-labels-idx1-ubyte";

    public File downloadAndUntar() throws IOException {
        if (this.fileDir != null) {
            return this.fileDir;
        }
        File tmpDir = new File(System.getProperty("user.home"));
        File baseDir = new File(tmpDir, LOCAL_DIR_NAME);
        if (!baseDir.isDirectory() && !baseDir.mkdir()) {
            throw new IOException("Could not mkdir " + baseDir);
        }
        log.info("Downloading mnist...");
        File tarFile = new File(baseDir, trainingFilesFilename);
        File tarFileLabels = new File(baseDir, testFilesFilename);
        if (!tarFile.isFile()) {
            FileUtils.copyURLToFile((URL)new URL(trainingFilesURL), (File)tarFile);
        }
        if (!tarFileLabels.isFile()) {
            FileUtils.copyURLToFile((URL)new URL(testFilesURL), (File)tarFileLabels);
        }
        ArchiveUtils.unzipFileTo(tarFile.getAbsolutePath(), baseDir.getAbsolutePath());
        ArchiveUtils.unzipFileTo(tarFileLabels.getAbsolutePath(), baseDir.getAbsolutePath());
        File labels = new File(baseDir, trainingFileLabelsFilename);
        File labelsTest = new File(baseDir, testFileLabelsFilename);
        if (!labels.isFile()) {
            FileUtils.copyURLToFile((URL)new URL(trainingFileLabelsURL), (File)labels);
        }
        if (!labelsTest.isFile()) {
            FileUtils.copyURLToFile((URL)new URL(testFileLabelsURL), (File)labelsTest);
        }
        ArchiveUtils.unzipFileTo(labels.getAbsolutePath(), baseDir.getAbsolutePath());
        ArchiveUtils.unzipFileTo(labelsTest.getAbsolutePath(), baseDir.getAbsolutePath());
        this.fileDir = baseDir;
        return this.fileDir;
    }

    public static void gunzipFile(File baseDir, File gzFile) throws IOException {
        String s;
        log.info("gunzip'ing File: " + gzFile.toString());
        Process p = Runtime.getRuntime().exec(String.format("gunzip %s", gzFile.getAbsolutePath()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        log.info("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            log.info(s);
        }
        stdError.close();
    }

    public File getBASE_DIR() {
        return this.BASE_DIR;
    }

    public File getFILE_DIR() {
        return this.FILE_DIR;
    }

    public File getFileDir() {
        return this.fileDir;
    }

    public void setBASE_DIR(File BASE_DIR) {
        this.BASE_DIR = BASE_DIR;
    }

    public void setFILE_DIR(File FILE_DIR) {
        this.FILE_DIR = FILE_DIR;
    }

    public void setFileDir(File fileDir) {
        this.fileDir = fileDir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MnistFetcher)) {
            return false;
        }
        MnistFetcher other = (MnistFetcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$BASE_DIR = this.getBASE_DIR();
        File other$BASE_DIR = other.getBASE_DIR();
        if (this$BASE_DIR == null ? other$BASE_DIR != null : !((Object)this$BASE_DIR).equals(other$BASE_DIR)) {
            return false;
        }
        File this$FILE_DIR = this.getFILE_DIR();
        File other$FILE_DIR = other.getFILE_DIR();
        if (this$FILE_DIR == null ? other$FILE_DIR != null : !((Object)this$FILE_DIR).equals(other$FILE_DIR)) {
            return false;
        }
        File this$fileDir = this.getFileDir();
        File other$fileDir = other.getFileDir();
        return !(this$fileDir == null ? other$fileDir != null : !((Object)this$fileDir).equals(other$fileDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MnistFetcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $BASE_DIR = this.getBASE_DIR();
        result = result * 59 + ($BASE_DIR == null ? 0 : ((Object)$BASE_DIR).hashCode());
        File $FILE_DIR = this.getFILE_DIR();
        result = result * 59 + ($FILE_DIR == null ? 0 : ((Object)$FILE_DIR).hashCode());
        File $fileDir = this.getFileDir();
        result = result * 59 + ($fileDir == null ? 0 : ((Object)$fileDir).hashCode());
        return result;
    }

    public String toString() {
        return "MnistFetcher(BASE_DIR=" + this.getBASE_DIR() + ", FILE_DIR=" + this.getFILE_DIR() + ", fileDir=" + this.getFileDir() + ")";
    }
}

