/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.termination;

import org.deeplearning4j.earlystopping.termination.EpochTerminationCondition;

public class ScoreImprovementEpochTerminationCondition
implements EpochTerminationCondition {
    private int maxEpochsWithNoImprovement;
    private int bestEpoch = -1;
    private double bestScore;

    public ScoreImprovementEpochTerminationCondition(int maxEpochsWithNoImprovement) {
        this.maxEpochsWithNoImprovement = maxEpochsWithNoImprovement;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean terminate(int epochNum, double score) {
        if (this.bestEpoch == -1) {
            this.bestEpoch = epochNum;
            this.bestScore = score;
            return false;
        }
        if (score < this.bestScore) {
            this.bestScore = score;
            this.bestEpoch = epochNum;
            return false;
        }
        return epochNum >= this.bestEpoch + this.maxEpochsWithNoImprovement;
    }

    public String toString() {
        return "ScoreImprovementEpochTerminationCondition(maxEpochsWithNoImprovement=" + this.maxEpochsWithNoImprovement + ")";
    }
}

