/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;
import org.nd4j.linalg.factory.Nd4j;

public class AsyncMultiDataSetIterator
implements MultiDataSetIterator {
    private final MultiDataSetIterator iterator;
    private final LinkedBlockingQueue<MultiDataSet> queue;
    private IteratorRunnable runnable;
    private Thread thread;

    public AsyncMultiDataSetIterator(MultiDataSetIterator iterator, int queueLength) {
        if (queueLength <= 0) {
            throw new IllegalArgumentException("Queue size must be > 0");
        }
        this.iterator = iterator;
        this.queue = new LinkedBlockingQueue(queueLength);
        this.runnable = new IteratorRunnable(iterator.hasNext());
        this.thread = new Thread(this.runnable);
        Integer deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
        Nd4j.getAffinityManager().attachThreadToDevice(this.thread, deviceId);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public MultiDataSet next(int num) {
        throw new UnsupportedOperationException("Next(int) not supported for AsyncDataSetIterator");
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.iterator.setPreProcessor(preProcessor);
    }

    public void reset() {
        this.runnable.killRunnable = true;
        if (this.runnable.isAlive) {
            this.thread.interrupt();
        }
        try {
            this.runnable.runCompletedSemaphore.tryAcquire(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.queue.clear();
        this.iterator.reset();
        this.runnable = new IteratorRunnable(this.iterator.hasNext());
        this.thread = new Thread(this.runnable);
        Integer deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
        Nd4j.getAffinityManager().attachThreadToDevice(this.thread, deviceId);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public boolean hasNext() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        if (this.runnable.isAlive) {
            return true;
        }
        if (!this.runnable.killRunnable && this.runnable.exception != null) {
            throw this.runnable.exception;
        }
        return !this.queue.isEmpty();
    }

    public MultiDataSet next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.runnable.exception != null) {
            throw this.runnable.exception;
        }
        if (!this.queue.isEmpty()) {
            return this.queue.poll();
        }
        try {
            while (this.runnable.exception == null) {
                MultiDataSet ds = this.queue.poll(5L, TimeUnit.SECONDS);
                if (ds != null) {
                    return ds;
                }
                if (this.runnable.killRunnable) {
                    throw new ConcurrentModificationException("Reset while next() is waiting for element?");
                }
                if (this.runnable.isAlive || !this.queue.isEmpty()) continue;
                throw new IllegalStateException("Unexpected state occurred for AsyncMultiDataSetIterator: runnable died or no data available");
            }
            throw this.runnable.exception;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove() {
    }

    public void shutdown() {
        if (this.thread.isAlive()) {
            this.runnable.killRunnable = true;
            this.thread.interrupt();
        }
    }

    private class IteratorRunnable
    implements Runnable {
        private volatile boolean killRunnable = false;
        private volatile boolean isAlive = true;
        private volatile RuntimeException exception;
        private Semaphore runCompletedSemaphore = new Semaphore(0);

        public IteratorRunnable(boolean hasNext) {
            this.isAlive = hasNext;
        }

        @Override
        public void run() {
            try {
                while (!this.killRunnable && AsyncMultiDataSetIterator.this.iterator.hasNext()) {
                    AsyncMultiDataSetIterator.this.queue.put(AsyncMultiDataSetIterator.this.iterator.next());
                }
            }
            catch (InterruptedException e) {
                if (this.killRunnable) {
                    return;
                }
                this.exception = new RuntimeException("Runnable interrupted unexpectedly", e);
            }
            catch (RuntimeException e) {
                this.exception = e;
            }
            finally {
                this.isAlive = false;
                this.runCompletedSemaphore.release();
            }
        }
    }
}

