/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.List;
import org.deeplearning4j.datasets.fetchers.BaseDataFetcher;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class BaseDatasetIterator
implements DataSetIterator {
    protected int batch;
    protected int numExamples;
    protected BaseDataFetcher fetcher;
    protected DataSetPreProcessor preProcessor;

    public BaseDatasetIterator(int batch, int numExamples, BaseDataFetcher fetcher) {
        this.batch = batch;
        if (numExamples < 0) {
            numExamples = fetcher.totalExamples();
        }
        this.numExamples = numExamples;
        this.fetcher = fetcher;
    }

    public boolean hasNext() {
        return this.fetcher.hasMore() && this.fetcher.cursor() < this.numExamples;
    }

    public org.nd4j.linalg.dataset.DataSet next() {
        this.fetcher.fetch(this.batch);
        org.nd4j.linalg.dataset.DataSet result = this.fetcher.next();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)result);
        }
        return result;
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        this.fetcher.fetch(num);
        org.nd4j.linalg.dataset.DataSet next = this.fetcher.next();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)next);
        }
        return next;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int totalExamples() {
        return this.fetcher.totalExamples();
    }

    public int inputColumns() {
        return this.fetcher.inputColumns();
    }

    public int totalOutcomes() {
        return this.fetcher.totalOutcomes();
    }

    public void reset() {
        this.fetcher.reset();
    }

    public int batch() {
        return this.batch;
    }

    public int cursor() {
        return this.fetcher.cursor();
    }

    public int numExamples() {
        return this.numExamples;
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public List<String> getLabels() {
        return null;
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }
}

