/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.beans.ConstructorProperties;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.nd4j.linalg.factory.Nd4j;

public class BatchNormalization
extends FeedForwardLayer {
    protected double decay;
    protected double eps = Nd4j.EPS_THRESHOLD;
    protected boolean useBatchMean;
    protected double gamma;
    protected double beta;
    protected boolean lockGammaBeta;

    private BatchNormalization(Builder builder) {
        super(builder);
        this.decay = builder.decay;
        this.useBatchMean = builder.useBatchMean;
        this.gamma = builder.gamma;
        this.beta = builder.beta;
        this.lockGammaBeta = builder.lockGammaBeta;
    }

    @Override
    public BatchNormalization clone() {
        BatchNormalization clone = (BatchNormalization)super.clone();
        return clone;
    }

    public double getDecay() {
        return this.decay;
    }

    public double getEps() {
        return this.eps;
    }

    public boolean isUseBatchMean() {
        return this.useBatchMean;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getBeta() {
        return this.beta;
    }

    public boolean isLockGammaBeta() {
        return this.lockGammaBeta;
    }

    public void setDecay(double decay) {
        this.decay = decay;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    public void setUseBatchMean(boolean useBatchMean) {
        this.useBatchMean = useBatchMean;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public void setLockGammaBeta(boolean lockGammaBeta) {
        this.lockGammaBeta = lockGammaBeta;
    }

    public BatchNormalization() {
    }

    @Override
    public String toString() {
        return "BatchNormalization(super=" + super.toString() + ", decay=" + this.getDecay() + ", eps=" + this.getEps() + ", useBatchMean=" + this.isUseBatchMean() + ", gamma=" + this.getGamma() + ", beta=" + this.getBeta() + ", lockGammaBeta=" + this.isLockGammaBeta() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchNormalization)) {
            return false;
        }
        BatchNormalization other = (BatchNormalization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getDecay(), other.getDecay()) != 0) {
            return false;
        }
        if (Double.compare(this.getEps(), other.getEps()) != 0) {
            return false;
        }
        if (this.isUseBatchMean() != other.isUseBatchMean()) {
            return false;
        }
        if (Double.compare(this.getGamma(), other.getGamma()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta(), other.getBeta()) != 0) {
            return false;
        }
        return this.isLockGammaBeta() == other.isLockGammaBeta();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BatchNormalization;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $decay = Double.doubleToLongBits(this.getDecay());
        result = result * 59 + (int)($decay >>> 32 ^ $decay);
        long $eps = Double.doubleToLongBits(this.getEps());
        result = result * 59 + (int)($eps >>> 32 ^ $eps);
        result = result * 59 + (this.isUseBatchMean() ? 79 : 97);
        long $gamma = Double.doubleToLongBits(this.getGamma());
        result = result * 59 + (int)($gamma >>> 32 ^ $gamma);
        long $beta = Double.doubleToLongBits(this.getBeta());
        result = result * 59 + (int)($beta >>> 32 ^ $beta);
        result = result * 59 + (this.isLockGammaBeta() ? 79 : 97);
        return result;
    }

    public static class Builder
    extends FeedForwardLayer.Builder<Builder> {
        protected double decay = 0.9;
        protected boolean useBatchMean = true;
        protected boolean lockGammaBeta = false;
        protected double gamma = 1.0;
        protected double beta = 0.0;

        public Builder(double decay, boolean useBatchMean) {
            this.decay = decay;
            this.useBatchMean = useBatchMean;
        }

        public Builder(double gamma, double beta) {
            this.gamma = gamma;
            this.beta = beta;
        }

        public Builder(double gamma, double beta, boolean lockGammaBeta) {
            this.gamma = gamma;
            this.beta = beta;
            this.lockGammaBeta = lockGammaBeta;
        }

        public Builder(boolean lockGammaBeta) {
            this.lockGammaBeta = lockGammaBeta;
        }

        public Builder() {
        }

        public Builder gamma(double gamma) {
            this.gamma = gamma;
            return this;
        }

        public Builder beta(double beta) {
            this.beta = beta;
            return this;
        }

        public Builder decay(double decay) {
            this.decay = decay;
            return this;
        }

        public Builder lockGammaBeta(boolean lockGammaBeta) {
            this.lockGammaBeta = lockGammaBeta;
            return this;
        }

        @Override
        public BatchNormalization build() {
            return new BatchNormalization(this);
        }

        @ConstructorProperties(value={"decay", "useBatchMean", "lockGammaBeta", "gamma", "beta"})
        public Builder(double decay, boolean useBatchMean, boolean lockGammaBeta, double gamma, double beta) {
            this.decay = decay;
            this.useBatchMean = useBatchMean;
            this.lockGammaBeta = lockGammaBeta;
            this.gamma = gamma;
            this.beta = beta;
        }
    }
}

