/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.base;

import java.io.File;
import java.io.IOException;
import org.deeplearning4j.datasets.base.MnistFetcher;
import org.eclipse.deeplearning4j.resources.DataSetResource;
import org.eclipse.deeplearning4j.resources.ResourceDataSets;
import org.eclipse.deeplearning4j.resources.utils.EMnistSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmnistFetcher
extends MnistFetcher {
    private static final Logger log = LoggerFactory.getLogger(EmnistFetcher.class);
    private final EMnistSet ds;
    private DataSetResource emnistDataTrain;
    private DataSetResource emnistDataTest;
    private DataSetResource emnistLabelsTrain;
    private DataSetResource emnistLabelsTest;
    private DataSetResource emnistMappingTrain;
    private DataSetResource emnistMappingTest;

    public EmnistFetcher() {
        this(EMnistSet.MNIST);
    }

    public EmnistFetcher(EMnistSet ds) {
        this.ds = ds;
        this.emnistDataTrain = ResourceDataSets.emnistTrain((EMnistSet)ds);
        this.emnistDataTest = ResourceDataSets.emnistTest((EMnistSet)ds);
        this.emnistLabelsTrain = ResourceDataSets.emnistLabelsTrain((EMnistSet)ds);
        this.emnistLabelsTest = ResourceDataSets.emnistLabelsTest((EMnistSet)ds);
        this.emnistMappingTrain = ResourceDataSets.emnistMappingTrain((EMnistSet)ds);
        this.emnistMappingTest = ResourceDataSets.emnistMappingTest((EMnistSet)ds);
    }

    public EmnistFetcher(EMnistSet ds, File topLevelDir) {
        this.ds = ds;
        this.emnistDataTrain = ResourceDataSets.emnistTrain((EMnistSet)ds, (File)topLevelDir);
        this.emnistDataTest = ResourceDataSets.emnistTest((EMnistSet)ds, (File)topLevelDir);
        this.emnistLabelsTrain = ResourceDataSets.emnistLabelsTrain((EMnistSet)ds, (File)topLevelDir);
        this.emnistLabelsTest = ResourceDataSets.emnistLabelsTest((EMnistSet)ds, (File)topLevelDir);
        this.emnistMappingTrain = ResourceDataSets.emnistMappingTrain((EMnistSet)ds, (File)topLevelDir);
        this.emnistMappingTest = ResourceDataSets.emnistMappingTest((EMnistSet)ds, (File)topLevelDir);
    }

    @Override
    public String getName() {
        return "EMNIST";
    }

    public static int numLabels(EMnistSet dataSet) {
        switch (dataSet) {
            case COMPLETE: {
                return 62;
            }
            case MERGE: {
                return 47;
            }
            case BALANCED: {
                return 47;
            }
            case LETTERS: {
                return 26;
            }
            case DIGITS: {
                return 10;
            }
            case MNIST: {
                return 10;
            }
        }
        throw new UnsupportedOperationException("Unknown Set: " + dataSet);
    }

    @Override
    public File downloadAndUntar() throws IOException {
        if (this.fileDir != null) {
            return this.fileDir;
        }
        File baseDir = this.getBaseDir();
        if (!baseDir.isDirectory() && !baseDir.mkdir()) {
            throw new IOException("Could not mkdir " + baseDir);
        }
        log.info("Downloading {}...", (Object)this.getName());
        this.emnistDataTrain.download(true, 3, 300000, 30000);
        this.emnistDataTest.download(true, 3, 300000, 30000);
        this.emnistLabelsTrain.download(true, 3, 300000, 30000);
        this.emnistLabelsTest.download(true, 3, 300000, 30000);
        this.emnistMappingTrain.download(false, 3, 300000, 30000);
        this.emnistMappingTest.download(false, 3, 300000, 30000);
        this.fileDir = baseDir;
        return this.fileDir;
    }

    public DataSetResource getEmnistDataTrain() {
        return this.emnistDataTrain;
    }

    public DataSetResource getEmnistDataTest() {
        return this.emnistDataTest;
    }

    public DataSetResource getEmnistLabelsTrain() {
        return this.emnistLabelsTrain;
    }

    public DataSetResource getEmnistLabelsTest() {
        return this.emnistLabelsTest;
    }

    public DataSetResource getEmnistMappingTrain() {
        return this.emnistMappingTrain;
    }

    public DataSetResource getEmnistMappingTest() {
        return this.emnistMappingTest;
    }
}

