/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.common.resources.ResourceType;
import org.deeplearning4j.datasets.fetchers.CacheableDataSet;
import org.deeplearning4j.datasets.fetchers.DataSetType;
import org.nd4j.common.util.ArchiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheableExtractableDataSetFetcher
implements CacheableDataSet {
    private static final Logger log = LoggerFactory.getLogger(CacheableExtractableDataSetFetcher.class);

    @Override
    public String dataSetName(DataSetType set) {
        return "";
    }

    @Override
    public String remoteDataUrl() {
        return this.remoteDataUrl(DataSetType.TRAIN);
    }

    @Override
    public long expectedChecksum() {
        return this.expectedChecksum(DataSetType.TRAIN);
    }

    public void downloadAndExtract() throws IOException {
        this.downloadAndExtract(DataSetType.TRAIN);
    }

    public void downloadAndExtract(DataSetType set) throws IOException {
        File localDestinationDir;
        File[] list;
        String localFilename = new File(this.remoteDataUrl(set)).getName();
        File tmpFile = new File(System.getProperty("java.io.tmpdir"), localFilename);
        File localCacheDir = this.getLocalCacheDir();
        if (localCacheDir.exists() && ((list = localCacheDir.listFiles()) == null || list.length == 0)) {
            localCacheDir.delete();
        }
        if ((localDestinationDir = new File(localCacheDir, this.dataSetName(set))).exists()) {
            log.info("Using cached dataset at " + localCacheDir.getAbsolutePath());
            return;
        }
        localCacheDir.mkdirs();
        tmpFile.delete();
        log.info("Downloading dataset to " + tmpFile.getAbsolutePath());
        FileUtils.copyURLToFile((URL)new URL(this.remoteDataUrl(set)), (File)tmpFile);
        if (this.expectedChecksum(set) != 0L) {
            log.info("Verifying download...");
            Adler32 adler = new Adler32();
            FileUtils.checksum((File)tmpFile, (Checksum)adler);
            long localChecksum = adler.getValue();
            log.info("Checksum local is " + localChecksum + ", expecting " + this.expectedChecksum(set));
            if (this.expectedChecksum(set) != localChecksum) {
                log.error("Checksums do not match. Cleaning up files and failing...");
                tmpFile.delete();
                throw new IllegalStateException("Dataset file failed checksum: " + tmpFile + " - expected checksum " + this.expectedChecksum(set) + " vs. actual checksum " + localChecksum + ". If this error persists, please open an issue at https://github.com/eclipse/deeplearning4j.");
            }
        }
        try {
            ArchiveUtils.unzipFileTo((String)tmpFile.getAbsolutePath(), (String)localCacheDir.getAbsolutePath(), (boolean)false);
        }
        catch (Throwable t) {
            if (localCacheDir.exists()) {
                FileUtils.deleteDirectory((File)localCacheDir);
            }
            throw t;
        }
    }

    protected File getLocalCacheDir() {
        return DL4JResources.getDirectory((ResourceType)ResourceType.DATASET, (String)this.localCacheName());
    }

    @Override
    public boolean isCached() {
        return this.getLocalCacheDir().exists();
    }

    protected static void deleteIfEmpty(File localCache) {
        File[] files;
        if (localCache.exists() && ((files = localCache.listFiles()) == null || files.length < 1)) {
            try {
                FileUtils.deleteDirectory((File)localCache);
            }
            catch (IOException e) {
                log.debug("Error deleting directory: {}", (Object)localCache);
            }
        }
    }
}

